package com.pcloud.book.advertising.dao.impl;

import com.pcloud.book.advertising.dao.AdvertisingGroupTagDao;
import com.pcloud.book.advertising.entity.AdvertisingGroupTag;
import com.pcloud.common.core.dao.BaseDaoImpl;

import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @描述：群标记广告主
 * @作者：zhuyajie
 * @创建时间：14:53 2019/8/21
 * @版本：1.0
 */
@Component("advertisingGroupTagDao")
public class AdvertisingGroupTagDaoImpl extends BaseDaoImpl<AdvertisingGroupTag> implements AdvertisingGroupTagDao {

    @Override
    public void deleteByMasterId(Long masterId) {
        getSessionTemplate().delete(getStatement("deleteByMasterId"), masterId);
    }

    @Override
    public List<Long> getBookIdsByMasterId(Long masterId) {
        return getSessionTemplate().selectList(getStatement("getBookIdsByMasterId"), masterId);
    }

    @Override
    public void deleteByGroupQrcodeId(Long groupQrcodeId) {
        getSessionTemplate().delete(getStatement("deleteByGroupQrcodeId"), groupQrcodeId);
    }

    @Override
    public List<Long> getGroupQrcodeIdsByMasterId(Long masterId) {
        return getSessionTemplate().selectList(getStatement("getGroupQrcodeIdsByMasterId"), masterId);
    }

    @Override
    public void deleteByBook(List<Long> bookIds, Long masterId) {
        Map<String, Object> map = new HashMap<>();
        map.put("bookIds", bookIds);
        map.put("masterId", masterId);
        getSessionTemplate().delete(getStatement("deleteByBook"), map);
    }

    @Override
    public List<String> getTagWxGroupIdsByMasterId(Long masterId) {
        return getSessionTemplate().selectList(getStatement("getTagWxGroupIdsByMasterId"), masterId);
    }

    @Override
    public List<Long> getMasterIdsByBookId(Long bookId) {
        return getSessionTemplate().selectList(getStatement("getMasterIdsByBookId"), bookId);
    }
}
