package com.pcloud.book.advertising.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.book.advertising.entity.AdvertisingMaster;
import com.pcloud.common.dto.BaseDto;

import java.util.Date;
import java.util.List;

/**
 * @描述：群广告主标记列表
 * @作者：zhuyajie
 * @创建时间：15:00 2019/8/21
 * @版本：1.0
 */
public class GroupMasterDTO extends BaseDto{
    /**
     * 微信群id
     */
    private String wxGroupId;
    /**
     * 群二维码id
     */
    private Long groupQrcodeId;
    /**
     * 微信群名称
     */
    private String groupName;
    /**
     * 图书名称
     */
    private String bookName;
    /**
     * 群分类名称
     */
    private String classify;
    /**
     * 专业标签ID
     */
    private Long proLabelId;

    /**
     * 专业标签名称
     */
    private String proLabelName;
    /**
     * 深度标签ID
     */
    private Long depLabelId;

    /**
     * 深度标签名称
     */
    private String depLabelName;

    /**
     * 目的标签ID
     */
    private Long purLabelId;

    /**
     * 目的标签名称
     */
    private String purLabelName;
    /**
     * 出版社名称
     */
    private String agentName;
    /**
     * 编辑id
     */
    private Long adviserId;
    /**
     * 编辑名称
     */
    private String adviserName;
    /**
     * 活跃度
     */
    private Integer activeCount;
    /**
     * 当前群人数
     */
    private Integer userNumber;
    /**
     * 广告位数量
     */
    private Integer advertisingSpaceNum;
    /**
     * 群二维码url
     */
    private String qrcodeUrl;
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date createTime;
    /**
     * 标记的广告主列表
     */
    List<AdvertisingMaster> masterList;
    /**
     * 标记时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date tagTime;

    /**
     * isbn
     */
    private String isbn;
    public String getWxGroupId() {
        return wxGroupId;
    }

    public void setWxGroupId(String wxGroupId) {
        this.wxGroupId = wxGroupId;
    }

    public Long getGroupQrcodeId() {
        return groupQrcodeId;
    }

    public void setGroupQrcodeId(Long groupQrcodeId) {
        this.groupQrcodeId = groupQrcodeId;
    }

    public String getGroupName() {
        return groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public String getBookName() {
        return bookName;
    }

    public void setBookName(String bookName) {
        this.bookName = bookName;
    }

    public String getClassify() {
        return classify;
    }

    public void setClassify(String classify) {
        this.classify = classify;
    }

    public Long getProLabelId() {
        return proLabelId;
    }

    public void setProLabelId(Long proLabelId) {
        this.proLabelId = proLabelId;
    }

    public String getProLabelName() {
        return proLabelName;
    }

    public void setProLabelName(String proLabelName) {
        this.proLabelName = proLabelName;
    }

    public Long getDepLabelId() {
        return depLabelId;
    }

    public void setDepLabelId(Long depLabelId) {
        this.depLabelId = depLabelId;
    }

    public String getDepLabelName() {
        return depLabelName;
    }

    public void setDepLabelName(String depLabelName) {
        this.depLabelName = depLabelName;
    }

    public Long getPurLabelId() {
        return purLabelId;
    }

    public void setPurLabelId(Long purLabelId) {
        this.purLabelId = purLabelId;
    }

    public String getPurLabelName() {
        return purLabelName;
    }

    public void setPurLabelName(String purLabelName) {
        this.purLabelName = purLabelName;
    }

    public String getAgentName() {
        return agentName;
    }

    public void setAgentName(String agentName) {
        this.agentName = agentName;
    }

    public Long getAdviserId() {
        return adviserId;
    }

    public void setAdviserId(Long adviserId) {
        this.adviserId = adviserId;
    }

    public String getAdviserName() {
        return adviserName;
    }

    public void setAdviserName(String adviserName) {
        this.adviserName = adviserName;
    }

    public Integer getActiveCount() {
        return activeCount;
    }

    public void setActiveCount(Integer activeCount) {
        this.activeCount = activeCount;
    }

    public Integer getUserNumber() {
        return userNumber;
    }

    public void setUserNumber(Integer userNumber) {
        this.userNumber = userNumber;
    }

    public Integer getAdvertisingSpaceNum() {
        return advertisingSpaceNum;
    }

    public void setAdvertisingSpaceNum(Integer advertisingSpaceNum) {
        this.advertisingSpaceNum = advertisingSpaceNum;
    }

    public String getQrcodeUrl() {
        return qrcodeUrl;
    }

    public void setQrcodeUrl(String qrcodeUrl) {
        this.qrcodeUrl = qrcodeUrl;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public List<AdvertisingMaster> getMasterList() {
        return masterList;
    }

    public void setMasterList(List<AdvertisingMaster> masterList) {
        this.masterList = masterList;
    }

    public Date getTagTime() {
        return tagTime;
    }

    public void setTagTime(Date tagTime) {
        this.tagTime = tagTime;
    }

    public String getIsbn() {
        return isbn;
    }

    public void setIsbn(String isbn) {
        this.isbn = isbn;
    }

    @Override
    public String toString() {
        return "GroupMasterDTO{" +
                "wxGroupId='" + wxGroupId + '\'' +
                ", groupQrcodeId=" + groupQrcodeId +
                ", groupName='" + groupName + '\'' +
                ", bookName='" + bookName + '\'' +
                ", classify='" + classify + '\'' +
                ", proLabelId=" + proLabelId +
                ", proLabelName='" + proLabelName + '\'' +
                ", depLabelId=" + depLabelId +
                ", depLabelName='" + depLabelName + '\'' +
                ", purLabelId=" + purLabelId +
                ", purLabelName='" + purLabelName + '\'' +
                ", agentName='" + agentName + '\'' +
                ", adviserId=" + adviserId +
                ", adviserName='" + adviserName + '\'' +
                ", activeCount=" + activeCount +
                ", userNumber=" + userNumber +
                ", advertisingSpaceNum=" + advertisingSpaceNum +
                ", qrcodeUrl='" + qrcodeUrl + '\'' +
                ", createTime=" + createTime +
                ", masterList=" + masterList +
                ", tagTime=" + tagTime +
                ", isbn='" + isbn + '\'' +
                '}';
    }
}
