/**
 * 
 */
package com.pcloud.book.consumer.user;

import java.util.List;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.utils.ResponseHandleUtil;
import com.pcloud.usercenter.common.dto.BookCaseParamDto;
import com.pcloud.usercenter.common.service.BookcaseService;

/**
 * @描述：书架中间类
 * @作者：songx
 * @创建时间：2016年11月17日,上午10:14:01 @版本：1.0
 */
@Component("bookcaseConsr")
public class BookcaseConsr {

	/**
	 * logger
	 */
	private static final Logger LOGGER = LoggerFactory.getLogger(BookcaseConsr.class);

	@Autowired
	private BookcaseService bookcaseService;

	/**
	 * 更换书架书籍所属权
	 */
	public void changeBookAdviser(Long adviserId, Long channelId, Long bookId) throws BizException {
		LOGGER.info("【书架-用户(消)】更换书架书籍所属权,<PARAM>.[adviserId]=" + adviserId + ", [channelId]=" + channelId
				+ ", [bookId]=" + bookId);
		try {
			bookcaseService.changeBookAdviser(bookId, channelId, adviserId);
		} catch (BizException e) {
			LOGGER.warn("【书架-用户(消)】更换书架书籍所属权,<ERROR>.[changeBookAdviser]:" + e.getMessage(), e);
			throw new BookBizException(e.getCode(), e.getMessage());
		} catch (Exception e) {
			LOGGER.error("【书架-用户(消)】更换书架书籍所属权,<ERROR>.[changeBookAdviser]:" + e.getMessage(), e);
			throw new BookBizException(BookBizException.INVOKE_USER_ERROR, "更换书架书籍所属权失败~!");
		}
		LOGGER.info("【书架-用户(消)】更换书架书籍所属权,<END>");
	}

	/**
	 * 获取书籍是否加入书架
	 */
	public Map<Long, Boolean> judgeBookExist(List<BookCaseParamDto> bcpDtoList) throws BizException {
		LOGGER.info("【书架-用户(消)】获取书籍是否加入书架,<PARAM>.[bcpDtoList]=" + bcpDtoList);
		Map<Long, Boolean> resultMap = null;
		try {
			resultMap = ResponseHandleUtil.parseMapResponse(bookcaseService.judgeBookExist(bcpDtoList), Long.class,
					Boolean.class);
		} catch (BizException e) {
			LOGGER.warn("【书架-用户(消)】获取书籍是否加入书架,<ERROR>.[changeBookAdviser]:" + e.getMessage(), e);
			throw new BookBizException(e.getCode(), e.getMessage());
		} catch (Exception e) {
			LOGGER.error("【书架-用户(消)】获取书籍是否加入书架,<ERROR>.[changeBookAdviser]:" + e.getMessage(), e);
			throw new BookBizException(BookBizException.INVOKE_USER_ERROR, "获取书籍是否加入书架失败~!");
		}
		LOGGER.info("【书架-用户(消)】获取书籍是否加入书架,<END>");
		return resultMap;
	}

	/**
	 * 删除读者书架上的书籍
	 */
	public void deleteBookForAdviser(Long bookId, Long channelId, Long adviserId) {
		LOGGER.info("【书架-用户(消)】删除读者书架上的书籍,<PARAM>.[bookId]=" + bookId + ",channelId=" + channelId + ",adviserId="
				+ adviserId);
		try {
			bookcaseService.deleteBookForAdviser(bookId, channelId, adviserId);
		} catch (BizException e) {
			LOGGER.warn("【书架-用户(消)】删除读者书架上的书籍,<ERROR>.[deleteBookForAdviser]:" + e.getMessage(), e);
			throw new BookBizException(e.getCode(), e.getMessage());
		} catch (Exception e) {
			LOGGER.error("【书架-用户(消)】删除读者书架上的书籍,<ERROR>.[deleteBookForAdviser]:" + e.getMessage(), e);
			throw new BookBizException(BookBizException.INVOKE_USER_ERROR, "删除读者书架上的书籍失败~!");
		}
		LOGGER.info("【书架-用户(消)】删除读者书架上的书籍,<END>");
	}
}