package com.pcloud.book.copyright.entity;

import com.pcloud.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;

/**
 * @author lily
 * @date 2018/12/3 11:02
 */
@ApiModel
public class BookAuthCode extends BaseEntity {

    private Long id;

    @ApiModelProperty("图书标识")
    private Long bookId;

    @ApiModelProperty("运营标识")
    private Long channelId;

    @ApiModelProperty("编辑标识")
    private Long adviserId;

    @ApiModelProperty("授权码")
    private String authCode;

    @ApiModelProperty("批次号")
    private String batchNum;

    @ApiModelProperty("完整授权码")
    private String fullCode;

    @ApiModelProperty("使用次数")
    private Integer useCount;

    @ApiModelProperty("创建方式")
    private Integer createType;

    @ApiModelProperty("创建人")
    private Long createdUser;

    @ApiModelProperty("创建时间")
    private Date createdDate;

    @ApiModelProperty("最后修改人")
    private Long lastModifiedUser;

    @ApiModelProperty("最后修改时间")
    private Date lastModifiedDate;

    public String getFullCode() {
        return fullCode;
    }

    public void setFullCode(String fullCode) {
        this.fullCode = fullCode;
    }

    @Override
    public Long getId() {
        return id;
    }

    public String getBatchNum() {
        return batchNum;
    }

    public void setBatchNum(String batchNum) {
        this.batchNum = batchNum;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    public Long getBookId() {
        return bookId;
    }

    public void setBookId(Long bookId) {
        this.bookId = bookId;
    }

    public Long getChannelId() {
        return channelId;
    }

    public void setChannelId(Long channelId) {
        this.channelId = channelId;
    }

    public Long getAdviserId() {
        return adviserId;
    }

    public void setAdviserId(Long adviserId) {
        this.adviserId = adviserId;
    }

    public String getAuthCode() {
        return authCode;
    }

    public void setAuthCode(String authCode) {
        this.authCode = authCode;
    }

    public Integer getUseCount() {
        return useCount;
    }

    public void setUseCount(Integer useCount) {
        this.useCount = useCount;
    }

    public Integer getCreateType() {
        return createType;
    }

    public void setCreateType(Integer createType) {
        this.createType = createType;
    }

    public Long getCreatedUser() {
        return createdUser;
    }

    public void setCreatedUser(Long createdUser) {
        this.createdUser = createdUser;
    }

    public Date getCreatedDate() {
        return createdDate;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public Long getLastModifiedUser() {
        return lastModifiedUser;
    }

    public void setLastModifiedUser(Long lastModifiedUser) {
        this.lastModifiedUser = lastModifiedUser;
    }

    public Date getLastModifiedDate() {
        return lastModifiedDate;
    }

    public void setLastModifiedDate(Date lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
    }

    @Override
    public String toString() {
        return "BookAuthCode{" +
                "id=" + id +
                ", bookId=" + bookId +
                ", channelId=" + channelId +
                ", adviserId=" + adviserId +
                ", authCode='" + authCode + '\'' +
                ", batchNum='" + batchNum + '\'' +
                ", fullCode='" + fullCode + '\'' +
                ", useCount=" + useCount +
                ", createType=" + createType +
                ", createdUser=" + createdUser +
                ", createdDate=" + createdDate +
                ", lastModifiedUser=" + lastModifiedUser +
                ", lastModifiedDate=" + lastModifiedDate +
                '}';
    }
}
