package com.pcloud.book.copyright.entity;

import com.pcloud.common.entity.BaseEntity;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author lily
 * @date 2018/12/5 10:37
 */
public class BookAuthOrder extends BaseEntity {

    @ApiModelProperty("图书授权金购买")
    private Long id;

    @ApiModelProperty("图书标识")
    private Long bookId;

    @ApiModelProperty("运营标识")
    private Long channelId;

    @ApiModelProperty("编辑标识")
    private Long adviserId;

    @ApiModelProperty("价格")
    private BigDecimal money;

    @ApiModelProperty("公众号标识")
    private Long accountSettingId;

    @ApiModelProperty("订单编号")
    private String orderNum;

    @ApiModelProperty("微信用户标识")
    private  Long wechatUserId;

    @ApiModelProperty("支付方式")
    private  Integer paymentSource;

    @ApiModelProperty("创建人")
    private Long createdUser;

    @ApiModelProperty("创建时间")
    private Date createdDate;

    @Override
    public Long getId() {
        return id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    public Long getBookId() {
        return bookId;
    }

    public void setBookId(Long bookId) {
        this.bookId = bookId;
    }

    public Long getChannelId() {
        return channelId;
    }

    public void setChannelId(Long channelId) {
        this.channelId = channelId;
    }

    public Long getAdviserId() {
        return adviserId;
    }

    public void setAdviserId(Long adviserId) {
        this.adviserId = adviserId;
    }

    public BigDecimal getMoney() {
        return money;
    }

    public void setMoney(BigDecimal money) {
        this.money = money;
    }

    public Long getAccountSettingId() {
        return accountSettingId;
    }

    public void setAccountSettingId(Long accountSettingId) {
        this.accountSettingId = accountSettingId;
    }

    public String getOrderNum() {
        return orderNum;
    }

    public void setOrderNum(String orderNum) {
        this.orderNum = orderNum;
    }

    public Long getWechatUserId() {
        return wechatUserId;
    }

    public void setWechatUserId(Long wechatUserId) {
        this.wechatUserId = wechatUserId;
    }

    public Long getCreatedUser() {
        return createdUser;
    }

    public void setCreatedUser(Long createdUser) {
        this.createdUser = createdUser;
    }

    public Date getCreatedDate() {
        return createdDate;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public Integer getPaymentSource() {
        return paymentSource;
    }

    public void setPaymentSource(Integer paymentSource) {
        this.paymentSource = paymentSource;
    }

    @Override
    public String toString() {
        return "BookAuthOrder{" +
                "id=" + id +
                ", bookId=" + bookId +
                ", channelId=" + channelId +
                ", adviserId=" + adviserId +
                ", money=" + money +
                ", accountSettingId=" + accountSettingId +
                ", orderNum='" + orderNum + '\'' +
                ", wechatUserId=" + wechatUserId +
                ", paymentSource=" + paymentSource +
                ", createdUser=" + createdUser +
                ", createdDate=" + createdDate +
                '}';
    }
}
