package com.pcloud.book.copyright.vo;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.stereotype.Component;

import java.io.Serializable;

/**
 * @author lily
 * @date 2018/12/5 14:08
 */
@ApiModel
@JsonInclude(JsonInclude.Include.NON_NULL)
public class CheckCodeParam implements Serializable {

    @ApiModelProperty("校验码")
    private String code;

    @ApiModelProperty("二维码标识")
    private Long sceneId;

    @ApiModelProperty("图书标识")
    private Long bookId;

    @ApiModelProperty("编辑标识")
    private Long adviserId;

    @ApiModelProperty("运营标识")
    private Long channelId;

    public Long getChannelId() {
        return channelId;
    }

    public void setChannelId(Long channelId) {
        this.channelId = channelId;
    }
    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Long getSceneId() {
        return sceneId;
    }

    public void setSceneId(Long sceneId) {
        this.sceneId = sceneId;
    }

    public Long getBookId() {
        return bookId;
    }

    public void setBookId(Long bookId) {
        this.bookId = bookId;
    }

    public Long getAdviserId() {
        return adviserId;
    }

    public void setAdviserId(Long adviserId) {
        this.adviserId = adviserId;
    }

    @Override
    public String toString() {
        return "CheckCodeParam{" +
                "code='" + code + '\'' +
                ", sceneId=" + sceneId +
                ", bookId=" + bookId +
                ", adviserId=" + adviserId +
                '}';
    }
}
