package com.pcloud.book.es.biz.impl;

import com.pcloud.book.es.biz.ESNewsBiz;
import com.pcloud.book.es.entity.ESNews;
import com.pcloud.book.es.repository.NewsRepository;
import com.pcloud.book.push.dao.NewsDao;
import com.pcloud.book.push.entity.News;
import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.utils.BeanUtils;
import com.pcloud.common.utils.ListUtils;
import com.pcloud.common.utils.string.StringUtil;
import org.elasticsearch.index.query.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;

/**
 * @Description
 * @Author ruansiyuan
 * @Date 2019/6/13 16:36
 **/
@Component("esNewsBiz")
public class ESNewsBizImpl implements ESNewsBiz {

    private static final Logger LOGGER = LoggerFactory.getLogger(ESNewsBizImpl.class);


    @Autowired
    private NewsRepository newsRepository;

    @Autowired
    private NewsDao newsDao;


    @ParamLog("导入全部")
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void addAllNewsToES() {
        Integer count = newsDao.count();
        LOGGER.info("总数:" + count);
        if (null == count || count <= 0) {
            return;
        }
        Long maxId = 0L;
        Integer index = 0;
        Integer offset = 10000;
        while (index * offset < count) {
            Date date=new Date();
            List<ESNews> list = newsDao.findAll(maxId, offset);
            LOGGER.info("查询10000用时" + (new Date().getTime() - date.getTime()));
            if (ListUtils.isEmpty(list)) {
                break;
            }
            Date date1=new Date();
            newsRepository.save(list);
            LOGGER.info("插入es10000用时" + (new Date().getTime() - date1.getTime()));
            maxId = Long.valueOf(list.get(list.size() - 1).getId());
            LOGGER.info("导入数据至" + maxId);
            index += 1;
        }
    }

    @ParamLog("新增新闻")
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void addNews(News news) {
        if (news == null) {
            return;
        }
        //查询之前有没有相同的
        News newsHas=newsDao.getByUrl(news.getUrl());
        if (newsHas!=null){
            LOGGER.info("该news已存在"+news.toString());
            return;
        }
        newsDao.insert(news);
        ESNews esNews = new ESNews();
        BeanUtils.copyProperties(news, esNews);
        esNews.setId(news.getId().toString());
        esNews.setCreateTime(new Date());
        newsRepository.save(esNews);
    }

    @ParamLog("查询新闻")
    @Override
    public List<ESNews> getNews(String title, List<Long> notInIds, Integer top) {
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (!StringUtil.isEmpty(title)) {
            MatchQueryBuilder matchQuery = QueryBuilders.matchQuery("title", title);
            boolQueryBuilder.must(matchQuery);
        }
        if (!ListUtils.isEmpty(notInIds)){
            TermsQueryBuilder termsQuery = QueryBuilders.termsQuery("id", notInIds);
            boolQueryBuilder.mustNot(termsQuery);
        }
        PageRequest pageRequest = new PageRequest(0, top);
        return newsRepository.search(boolQueryBuilder, pageRequest).getContent();
    }
}
