package com.pcloud.book.group.dao;

import com.pcloud.book.group.dto.JoinGroupCipherDTO;
import com.pcloud.book.group.entity.JoinGroupCipher;
import com.pcloud.common.core.dao.BaseDao;

import java.math.BigDecimal;
import java.util.List;

public interface JoinGroupCipherDao extends BaseDao<JoinGroupCipher> {
    JoinGroupCipher getByWechatUserId(Long wechatUserId,Long classifyId);

    JoinGroupCipher getByCipher(String cipher);

    JoinGroupCipherDTO getDTOByCipher(String cipher);

    void updateCipherStateToUsed(String cipher, String wxId);

    List<JoinGroupCipherDTO> getClassifyIdsByWxIdAndAltId(String wxId, String altId);

    void updateQrcodeId(String cipher, String wxId, Long qrcodeId);

    /**
     * 用户支付金额
     * @param wxId
     * @param qrcodeId
     * @return
     */
    BigDecimal getPayPrice(String wxId, Long qrcodeId);
}
