package com.pcloud.book.group.dto;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.pcloud.book.keywords.vo.ListKeywordVO;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.List;

/**
 * @Description
 * @Author ruansiyuan
 * @Date 2019/6/26 14:28
 **/
@JsonInclude(JsonInclude.Include.NON_NULL)
public class ClassifyKeywordDTO implements Serializable {

    @ApiModelProperty("分类id")
    private Long classifyId;

    @ApiModelProperty("分类名称")
    private String classify;

    @ApiModelProperty("群数量")
    private Integer groupCount;

    @ApiModelProperty("用户数量")
    private Integer userCount;

    private List<ListKeywordVO> listKeywordVOS;

    public Long getClassifyId() {
        return classifyId;
    }

    public void setClassifyId(Long classifyId) {
        this.classifyId = classifyId;
    }

    public String getClassify() {
        return classify;
    }

    public void setClassify(String classify) {
        this.classify = classify;
    }

    public Integer getGroupCount() {
        return groupCount;
    }

    public void setGroupCount(Integer groupCount) {
        this.groupCount = groupCount;
    }

    public Integer getUserCount() {
        return userCount;
    }

    public void setUserCount(Integer userCount) {
        this.userCount = userCount;
    }

    public List<ListKeywordVO> getListKeywordVOS() {
        return listKeywordVOS;
    }

    public void setListKeywordVOS(List<ListKeywordVO> listKeywordVOS) {
        this.listKeywordVOS = listKeywordVOS;
    }

    @Override
    public String toString() {
        return "ClassifyKeywordDTO{" +
                "classifyId=" + classifyId +
                ", classify='" + classify + '\'' +
                ", groupCount=" + groupCount +
                ", userCount=" + userCount +
                ", listKeywordVOS=" + listKeywordVOS +
                '}';
    }
}
