package com.pcloud.book.keywords.vo;

import com.fasterxml.jackson.annotation.JsonInclude;

import java.io.Serializable;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * @author lily
 * @date 2019/4/23 15:32
 */
@ApiModel
@JsonInclude(JsonInclude.Include.NON_NULL)
public class ReplyMessageVO implements Serializable {

    @ApiModelProperty("回复消息标识（新增不传）")
    private Long id;

    @ApiModelProperty("服务标识")
    private Long serveId;

    @ApiModelProperty("服务类型")
    private String serveType;

    @ApiModelProperty("内容")
    private String content;

    @ApiModelProperty("图片地址")
    private String picUrl;

    @ApiModelProperty("链接地址")
    private String linkUrl;

    @ApiModelProperty("描述信息")
    private String description;

    @ApiModelProperty("回复类型 1 文字 2 图片 3 链接  4 应用")
    private Integer replyType;

    public Integer getReplyType() {
        return replyType;
    }

    public void setReplyType(Integer replyType) {
        this.replyType = replyType;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getServeId() {
        return serveId;
    }

    public void setServeId(Long serveId) {
        this.serveId = serveId;
    }

    public String getServeType() {
        return serveType;
    }

    public void setServeType(String serveType) {
        this.serveType = serveType;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getPicUrl() {
        return picUrl;
    }

    public void setPicUrl(String picUrl) {
        this.picUrl = picUrl;
    }

    public String getLinkUrl() {
        return linkUrl;
    }

    public void setLinkUrl(String linkUrl) {
        this.linkUrl = linkUrl;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String toString() {
        return "ReplyMessageVO{" +
                "id=" + id +
                ", serveId=" + serveId +
                ", serveType='" + serveType + '\'' +
                ", content='" + content + '\'' +
                ", picUrl='" + picUrl + '\'' +
                ", linkUrl='" + linkUrl + '\'' +
                ", description='" + description + '\'' +
                ", replyType=" + replyType +
                '}';
    }
}
