/**
 *
 */
package com.pcloud.book.mq.event;

import com.pcloud.book.copyright.biz.BookExportRecordBiz;
import com.pcloud.common.utils.string.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;

/**
 * @author：songx
 * @date：2018年5月16日,下午5:11:03
 */
@Component("bookEvent")
public class BookEvent implements ApplicationListener<ContextRefreshedEvent> {

    /**
     *
     */
    private final static Logger LOGGER = LoggerFactory.getLogger(BookEvent.class);

    @Autowired
    private BookExportRecordBiz bookExportRecordBiz;

    /**
     * 目的：防止onApplicationEvent方法重复执行两次
     */
    private boolean bool = false;

    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (bool || !StringUtil.isEmpty(event.getApplicationContext().getParent().getApplicationName())) {
            return;
        }
        bool = true;
        //处理由于服务重启导致导出失败的文件
        handleExportFail();
    }

    private void handleExportFail() {
        bookExportRecordBiz.handleExportFail();
    }

}
