package com.pcloud.book.weixinclock.check.impl;

import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.book.clock.entity.BookClockInfo;
import com.pcloud.book.weixinclock.check.WeixinClockCheck;
import com.pcloud.book.weixinclock.dto.WeixinClockDto;
import com.pcloud.common.utils.ListUtils;
import com.pcloud.common.utils.string.StringUtil;

import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author 杨涛
 * @description 检查
 * @date 2019/8/20 10:19
 */
@Component("weixinClockCheck")
public class WeixinClockCheckImpl implements WeixinClockCheck {

    /**
     * 创建微信签到打卡时的参数校验
     * @param weixinClockDto
     */
    @Override
    public void checkParam4CreateWeixinClock(WeixinClockDto weixinClockDto) {
        if(StringUtil.isEmpty(weixinClockDto.getClockKeyword())){
            throw new BookBizException(BookBizException.ERROR,"缺少打卡关键词！");
        }
        if(StringUtil.isEmpty(weixinClockDto.getClockGuide())){
            throw new BookBizException(BookBizException.ERROR,"缺少打卡引导语！");
        }
        if(StringUtil.isEmpty(weixinClockDto.getClockIntroduction())){
            throw new BookBizException(BookBizException.ERROR,"缺少打卡简介！");
        }
        /*if(null == weixinClockDto.getClockPrizeId()){
            throw new BookBizException(BookBizException.ERROR,"缺少打卡的奖励应用ID！");
        }*/
    }
}
