package com.pcloud.book.adnews.enums;

import com.pcloud.book.advertising.enums.AdDetailModeEnum;
import org.springframework.amqp.rabbit.support.PublisherCallbackChannelImpl;

/**
 * 早晚报内容来源
 *
 * @author zhengyongqiang
 * @date 2019/8/6 17:50
 */
public enum AdContentFromEnum {

    WECHAT(0, "系统推荐公众号"),
    CUSTOM(1, "自定义内容 "),
    WECHAT_ADVISER(2,"自有公众号");

    public final Integer key;

    public final String name;

    AdContentFromEnum(Integer key, String name) {
        this.key = key;
        this.name = name;
    }

    public static String getNameByKey(String key) {
        AdContentFromEnum[] var1 = values();
        int var2 = var1.length;
        for (int var3 = 0; var3 < var2; ++var3) {
            AdContentFromEnum methodEnum = var1[var3];
            if (methodEnum.key.equals(key)) {
                return methodEnum.name;
            }
        }
        return null;
    }
}
