package com.pcloud.book.advertising.dao.impl;

import com.pcloud.book.advertising.dao.AdvertisingBrandDataDao;
import com.pcloud.book.advertising.dto.BrandDataDTO4Channel;
import com.pcloud.book.advertising.entity.AdvertisingBrandData;
import com.pcloud.common.core.dao.BaseDaoImpl;

import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @描述：品牌方数据修改
 * @作者：zhuyajie
 * @创建时间：11:49 2020/4/16
 * @版本：1.0
 */
@Component("dvertisingBrandDataDao")
public class AdvertisingBrandDataDaoImpl extends BaseDaoImpl<AdvertisingBrandData> implements AdvertisingBrandDataDao{


    @Override
    public List<AdvertisingBrandData> queryAll(AdvertisingBrandData advertisingBrandData) {
        return getSessionTemplate().selectList(getStatement("queryAll"),advertisingBrandData);
    }

    @Override
    public List<AdvertisingBrandData> getQrServeData4Channel(BrandDataDTO4Channel brandDataDTO4Channel) {
        Map<String,Object>map=new HashMap<>();
        map.put("fromType",brandDataDTO4Channel.getFromType());
        map.put("bookId",brandDataDTO4Channel.getBookId());
        map.put("sceneId",brandDataDTO4Channel.getSceneId());
        map.put("serveIdList",brandDataDTO4Channel.getServeIdList());
        map.put("adviserId",brandDataDTO4Channel.getAdviserId());
        map.put("channelId",brandDataDTO4Channel.getChannelId());
        return getSessionTemplate().selectList(getStatement("getQrServeData4Channel"),map);
    }

    @Override
    public List<AdvertisingBrandData> getQrData4Channel(BrandDataDTO4Channel brandDataDTO4Channel) {
        Map<String,Object>map=new HashMap<>();
        map.put("fromType",brandDataDTO4Channel.getFromType());
        map.put("bookId",brandDataDTO4Channel.getBookId());
        map.put("sceneIdList",brandDataDTO4Channel.getSceneIdList());
        map.put("adviserId",brandDataDTO4Channel.getAdviserId());
        map.put("channelId",brandDataDTO4Channel.getChannelId());
        return getSessionTemplate().selectList(getStatement("getQrData4Channel"),map);
    }

    @Override
    public List<AdvertisingBrandData> getBookAddByType(List<Long> bookIds, String addType) {
        Map<String,Object>map=new HashMap<>();
        map.put("bookIds",bookIds);
        map.put("addType",addType);
        return getSessionTemplate().selectList(getStatement("getBookAddByType"),map);
    }
}
