package com.pcloud.book.book.dao.impl;

import com.google.common.collect.Maps;

import com.pcloud.book.book.dao.KeywordWarehouseDetailDao;
import com.pcloud.book.book.entity.KeywordWarehouseDetail;
import com.pcloud.common.core.dao.BaseDaoImpl;

import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

@Component
public class KeywordWarehouseDetailDaoImpl extends BaseDaoImpl<KeywordWarehouseDetail> implements KeywordWarehouseDetailDao {

    @Override
    public int insertSelective(KeywordWarehouseDetail record) {
        return this.getSqlSession().insert("com.pcloud.book.book.dao.impl.KeywordWarehouseDetailDaoImpl.insertSelective", record);
    }

    @Override
    public KeywordWarehouseDetail selectByPrimaryKey(Long id) {
        return this.getSqlSession().selectOne("com.pcloud.book.book.dao.impl.KeywordWarehouseDetailDaoImpl.selectByPrimaryKey", id);
    }

    @Override
    public int updateByPrimaryKeySelective(KeywordWarehouseDetail record) {
        return this.getSqlSession().update("com.pcloud.book.book.dao.impl.KeywordWarehouseDetailDaoImpl.updateByPrimaryKeySelective", record);
    }

    @Override
    public int updateByPrimaryKey(KeywordWarehouseDetail record) {
        return this.getSqlSession().update("com.pcloud.book.book.dao.impl.KeywordWarehouseDetailDaoImpl.updateByPrimaryKey", record);
    }

    @Override
    public void deleteDetails(Long keywordId) {
        this.getSqlSession().update("com.pcloud.book.book.dao.impl.KeywordWarehouseDetailDaoImpl.deleteDetails", keywordId);
    }

    @Override
    public void addOne(Long adviserId, Long id) {
        Map<String, Object> map = Maps.newHashMap();
        map.put("adviserId", adviserId);
        map.put("id", id);
        this.getSqlSession().update("com.pcloud.book.book.dao.impl.KeywordWarehouseDetailDaoImpl.addOne", map);
    }

    @Override
    public List<KeywordWarehouseDetail> listByKeywordIds(List<Long> ids) {
        return this.getSqlSession().selectList("com.pcloud.book.book.dao.impl.KeywordWarehouseDetailDaoImpl.listByKeywordIds", ids);
    }

}
