package com.pcloud.book.copyright.constants;

import com.pcloud.common.constant.CacheConstant;

import java.util.HashMap;
import java.util.Map;

/**
 * @author lily
 * @date 2018/12/5 21:08
 */
public class CopyrightConstants {

    public static final String BOOK_AUTH_INFO = CacheConstant.BOOK + "BOOK_AUTH_INFO";


    public enum CreateType{
        /**
         * 自动创建
         */
        AUTO_CREATE(0,"自动创建"),
        /**
         * 批量导入
         */
        BATCH_IMPORT(1, "批量导入");

        private Integer value;
        private String name;
        CreateType(Integer value, String name){
            this.value = value;
            this.name = name;
        }

        public Integer getValue() {
            return value;
        }

        public String getName() {
            return name;
        }

        public static final Map<Integer, CreateType> CRATE_TYPE_MAP;

        static {
            CRATE_TYPE_MAP = new HashMap<>();
            CRATE_TYPE_MAP.put(0, AUTO_CREATE);
            CRATE_TYPE_MAP.put(1, BATCH_IMPORT);
        }
    }

}
