package com.pcloud.book.giftcoupon.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.book.applet.entity.AppletThirdResources;

import java.util.Date;
import java.util.List;

import lombok.Data;

@Data
public class MyGiftPackageDTO{

    /**
     * 券id
     */
    private Long id;
    /**
     * 封面图
     */
    private String coverPic;
    /**
     * 名称
     */
    private String title;
    /**
     * 有效期开始时间
     */
    @JsonFormat(
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    private Date validDateBegin;
    /**
     * 有效期结束时间
     */
    @JsonFormat(
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    private Date validDateEnd;
    /**
     * 面额
     */
    private Integer denomination;

    /**
     * 未使用数量
     */
    private Integer notUsedNum;

    /**
     * 券类型（2-书币券，1-课程券）
     */
    private Integer couponType;
    /**
     * 使用说明
     */
    private String instructions;

    /**
     * 课程券使用方式（1-链接兑取，2-复制码）
     */
    private Integer useType;
    /**
     * 兑换地址
     */
    private String exchangeAddress;


    /**
     * 使用时间
     */
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm",
            timezone = "GMT+8"
    )
    private Date useTime;

    /**
     * 领取id
     */
    private Long receiveId;

    /**
     * 失效状态 (1-已使用，2-已过期)
     */
    private Integer failureState;

    /**
     * 资源描述
     */
    private String resourceDesc;

    /**
     * 划线价
     */
    private String crossedPrice;

    /**
     * 应用于分类(分类id用逗号连接)
     */
    private String applyType;

    /**
     * 是否推荐到首页
     */
    private Boolean recToPage;

    /**
     * 作品还是应用
     */
    private String serveType;

    /**
     * 应用或者作品id
     */
    private Long serveId;

    private String linkUrl;

    /**
     * 第三方资源链接id
     */
    private Long thirdResourceId;

    /**
     * 应用于分类(分类中文用分号连接)
     */
    private String applyTypeTemplate;

    /**
     * 资源描述返回数组
     */
    private List<String> desc;

    /**
     * 作品或者应用信息
     */
    private ServeInfoDTO serveInfoDTO;

    /**
     * 课程券第三方链接对象
     */
    private AppletThirdResources appletThirdResources;

    /**
     * 是否上架
     */
    private Boolean onShelves;



}
