package com.pcloud.book.riddle.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.common.entity.BaseEntity;

import java.util.Date;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel("谜语")
public class Riddle extends BaseEntity{

    @ApiModelProperty("谜面")
    private String riddleContent;

    @ApiModelProperty("谜底")
    private String answer;

    @ApiModelProperty("备选谜底")
    private String otherAnswer;

    @ApiModelProperty("等级")
    private Integer grade;

    @ApiModelProperty("序号")
    private Integer seq;

    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    @ApiModelProperty("创建时间")
    private Date createTime;

    public String getRiddleContent() {
        return riddleContent;
    }

    public void setRiddleContent(String riddleContent) {
        this.riddleContent = riddleContent == null ? null : riddleContent.trim();
    }

    public String getAnswer() {
        return answer;
    }

    public void setAnswer(String answer) {
        this.answer = answer == null ? null : answer.trim();
    }

    public String getOtherAnswer() {
        return otherAnswer;
    }

    public void setOtherAnswer(String otherAnswer) {
        this.otherAnswer = otherAnswer;
    }

    public Integer getGrade() {
        return grade;
    }

    public void setGrade(Integer grade) {
        this.grade = grade;
    }

    public Integer getSeq() {
        return seq;
    }

    public void setSeq(Integer seq) {
        this.seq = seq;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    @Override
    public String toString() {
        return "Riddle{" +
                "riddleContent='" + riddleContent + '\'' +
                ", answer='" + answer + '\'' +
                ", otherAnswer='" + otherAnswer + '\'' +
                ", grade=" + grade +
                ", seq=" + seq +
                ", createTime=" + createTime +
                '}';
    }
}