package com.pcloud.book.sentry;

import com.pcloud.book.book.constant.BookConstant;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import com.pcloud.common.enums.SystemEnvEnum;

import io.sentry.Sentry;
import lombok.extern.slf4j.Slf4j;

@Component
@Order(value = 1)
@Slf4j
public class SentryConfig implements ApplicationRunner {

    @Value("${system.env}")
    private String envStr;

    @Value("${book.dsn}")
    private String dsn;

    @Override
    public void run(ApplicationArguments applicationArguments) throws Exception {
        if (!SystemEnvEnum.PREF.value.equalsIgnoreCase(envStr)) {
            log.info("sentry初始化：{}", dsn + "?environment=" + envStr+"&timeout=10000");
            Sentry.init(dsn + "?environment=" + envStr);
        }
    }
}
