package com.pcloud.book.timecontrol.mapper;


import com.pcloud.book.timecontrol.entity.TimeControlSelfPlanFeedback;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Component;

import java.util.List;

@Component("selfPlanFeedBackMapper")
public interface TimeControlSelfPlanFeedbackMapper {

    void insert(TimeControlSelfPlanFeedback selfPlanFeedback);

    void batchInsert(List<TimeControlSelfPlanFeedback> selfPlanFeedbackList);

    void update(TimeControlSelfPlanFeedback selfPlanFeedback);

    List<TimeControlSelfPlanFeedback> getFeedbackByPlan(@Param("planId")Integer planId, @Param("feedbackType")Integer feedbackType);

    void deleteById(@Param("id")Integer id);

    void deleteByPlanId(@Param("planId") Integer planId, @Param("feedbackType")Integer feedbackType);

    List<TimeControlSelfPlanFeedback> listFeedback(@Param("planId") Integer planId, @Param("pageNum") int pageNum, @Param("numPerPage") int numPerPage);

    Integer listFeedbackCount(Integer planId);
}