package com.pcloud.book.timecontrol.vo.request;

import com.pcloud.book.timecontrol.entity.TimeControlTaskPrize;
import com.pcloud.book.timecontrol.enums.TaskPrizeTypeEnum;
import com.pcloud.common.utils.BeanUtils;
import lombok.Data;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import java.util.Date;

@Data
public class SavePrize4TaskItemVO{
    @NotNull(message = "taskId不能为空")
    private Integer taskId;
    @NotNull(message = "taskItemId不能为空")
    private Integer taskItemId;
    @NotNull(message = "未设置是否开启优惠券奖励")
    private Integer hasCoupon;
    @NotNull(message = "未设置是否开启课程奖励")
    private Integer hasApp;
    @NotNull(message = "未设置是否开启证书奖励")
    private Integer hasCertificate;
    @Valid
    private PrizeCouponRequestVO coupon;
    @Valid
    private AppRequestVO app;
    @Valid
    private CertificateRequestVO certificate;

    public static TimeControlTaskPrize valueToTaskPrize(SavePrize4TaskItemVO vo){
        TimeControlTaskPrize taskPrize = new TimeControlTaskPrize();
        BeanUtils.copyProperties(vo, taskPrize);
        taskPrize.setType(TaskPrizeTypeEnum.SINGLE.key);
        taskPrize.setCreateTime(new Date());
        taskPrize.setUpdateTime(new Date());
        return taskPrize;
    }
}
