package com.pcloud.book.group.tools;

import com.pcloud.book.util.common.ThreadPoolUtils;
import com.pcloud.wechatgroup.selfrobot.dto.SelfRobotMsgRecord;
import com.pcloud.wechatgroup.selfrobot.service.SelfRobotService;
import com.sdk.wxgroup.SendGroupInviteVO;
import com.sdk.wxgroup.SendTextMessageVO;
import com.sdk.wxgroup.WxGroupSDK;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;

import lombok.extern.slf4j.Slf4j;

/**
 * @描述：1v1个人号发送消息
 * @作者：zhuyajie
 * @创建时间：18:02 2019/11/13
 * @版本：1.0
 */
@Slf4j
@Component
public class SendSelfMsgTools {


    @Autowired
    private SelfRobotService selfRobotService;

    private static SendSelfMsgTools sendSelfMsgTools;

    /**
     * 发送文本消息
     */
    public static void sendTextMessage(SendTextMessageVO sendTextMessageVO) {
        WxGroupSDK.sendTextMessage(sendTextMessageVO);
        ThreadPoolUtils.OTHER_THREAD_POOL.execute(() -> {
            SelfRobotMsgRecord selfRobotMsgRecord = new SelfRobotMsgRecord();
            selfRobotMsgRecord.setMessageType(1);//文本
            selfRobotMsgRecord.setTextContent(sendTextMessageVO.getContent());
            selfRobotMsgRecord.setWxId(sendTextMessageVO.getAltId());
            selfRobotMsgRecord.setWxUserId(sendTextMessageVO.getWxGroupId());
            insertMsg(selfRobotMsgRecord);
        });
    }

    /**
     * 发送入群邀请链接
     */
    public static void sendGroupInvite(SendGroupInviteVO sendGroupInviteVO) {
        WxGroupSDK.sendGroupInvite(sendGroupInviteVO);
        ThreadPoolUtils.OTHER_THREAD_POOL.execute(() -> {
            SelfRobotMsgRecord selfRobotMsgRecord = new SelfRobotMsgRecord();
            selfRobotMsgRecord.setMessageType(11);//链接
            selfRobotMsgRecord.setWxId(sendGroupInviteVO.getAltId());
            selfRobotMsgRecord.setWxUserId(sendGroupInviteVO.getWxId());
            selfRobotMsgRecord.setTitle("邀请你加入群聊");
            insertMsg(selfRobotMsgRecord);
        });
    }


    /**
     * 保存发送记录
     */
    public static void insertMsg(SelfRobotMsgRecord selfRobotMsgRecord) {
        try {
            sendSelfMsgTools.selfRobotService.addSelfRobotMsg(selfRobotMsgRecord);

        } catch (Exception e) {
            log.error("添加个人号消息记录失败" + e.getMessage(), e);
        }
    }

    @PostConstruct
    public void init() {
        sendSelfMsgTools = this;
        sendSelfMsgTools.selfRobotService = this.selfRobotService;
    }

}
