package com.pcloud.book.push.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.common.dto.BaseDto;

import java.util.Date;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @描述：个人号群发记录
 * @作者：zhuyajie
 * @创建时间：16:50 2019/11/27
 * @版本：1.0
 */
@Data
public class SelfPushRecordDTO extends BaseDto{

    @ApiModelProperty("群发小号id")
    private String altId;

    @ApiModelProperty("小号名称")
    private String robotName;

    @ApiModelProperty("推送id")
    private Long pushId;

    @ApiModelProperty("推送项id")
    private Long pushItemId;

    @ApiModelProperty("推送内容项类型：1文本,2链接,3应用,4图片")
    private Integer itemType;

    @ApiModelProperty("文本内容")
    private String textContent;

    @ApiModelProperty("链接地址")
    private String linkUrl;

    @ApiModelProperty("链接标题")
    private String linkTitle;

    @ApiModelProperty("链接简介")
    private String linkDescription;

    @ApiModelProperty("链接图片地址")
    private String linkImageUrl;

    @ApiModelProperty("图片链接")
    private String imageUrl;

    @ApiModelProperty("应用id")
    private Long appId;

    @ApiModelProperty("作品id")
    private Long productId;

    @ApiModelProperty("应用链接")
    private String appUrl;

    @ApiModelProperty("作品链接")
    private String productUrl;

    @ApiModelProperty("发送状态（0发送中1发送成功2发送失败）")
    private Integer pushStatus;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("发送好友数量")
    private Integer userCount;

}
