/**
 * 
 */
package com.pcloud.book.book.biz;

import com.pcloud.book.base.dto.CountDto;
import com.pcloud.book.book.dto.*;
import com.pcloud.book.book.entity.Book;
import com.pcloud.book.book.entity.BookAdviser;
import com.pcloud.book.book.vo.ErpAdviserBookVO;
import com.pcloud.book.book.vo.QrCodeVO;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.page.PageBeanNew;

import java.util.List;
import java.util.Map;

/**
 * @描述：编辑管理书籍逻辑层接口
 * @作者：songx
 * @创建时间：2016年12月30日,下午5:21:22
 * @版本：1.0
 */
public interface BookAdviserBiz {


	List<BookDto> listByAdviserId(Long adviserId);
	/**
	 * 创建编辑管理书籍关系
	 * 
	 * @param bookAdviser 图书编辑关联实体类
	 * @throws BizException
	 */
	public void create(BookAdviser bookAdviser) throws BizException;

	/**
	 * 删除编辑和书籍的推广信息
	 * 
	 * @param bookId 图书标识
	 * @return
	 */
	public void deleteByBook(Long bookId) throws BizException;

	/**
	 * 批量删除编辑和书籍的推广信息
	 * 
	 * @param bookIds 图书标识列表
	 * @throws BizException
	 */
	public void deleteByBooks(List<Long> bookIds) throws BizException;

	/**
	 * 获取编辑和书籍的关系
	 * 
	 * @param bookAdviser 图书编关联实体类
	 * @return
	 * @throws BizException
	 */
	public BookAdviserDto getByAdviser(BookAdviser bookAdviser) throws BizException;

	/**
	 * 获取编辑和书籍的关系
	 */
	 BookAdviserDto getBase(Long bookId, Long channelId, Long adviserId) throws BizException;

	/**
	 * 统计编辑推广的图书总数
	 * 
	 * @param adviserIds 编辑标识列表
	 * @return
	 */
	public Map<Long, BookAdviserDto> getCountByAdvisers(List<Long> adviserIds) throws BizException;

	/**
	 * 根据ISBN获取图书信息
	 * 
	 * @param isbn
	 * @param channelId 渠道标识
	 * @return
	 * @throws BizException
	 */
	BookAdviserDto getByIsbn(String isbn, Long channelId) throws BizException;

	/**
	 * 获取配置过书籍的编辑top1
	 * @param bookId 书籍标识
	 * @param channelId 渠道标识
	 * @return
	 */
	Long getAdviserTop1(Long bookId, Long channelId);
	
	/**
	 * 根据书籍和渠道删除书籍编辑关联信息
	 * 
	 * @param bookId 图书标识
	 * @param channelId 渠道标识
	 * @return
	 */
	void deleteByBookAndChannel(Long bookId, Long channelId) throws BizException;

	/**
	 * 根据图书信息获取主编辑ID
	 * @param bookId 图书标识
	 * @param channelId 渠道标识
	 */
	public Long getMainAdviserId(Long bookId, Long channelId);	
	
	/**
	 * 编辑管理--获取编辑列表（平台端）
	 * @param bookId 图书标识
	 */
	public List<AdviserManageDto> getAdviserList(Long bookId);

	/**
	 * 编辑管理--删除副编辑
	 * @param bookAdvisers 图书编辑实体列表
	 */
	public void delViceAdviser(List<BookAdviser> bookAdvisers);

	/**
	 * 创建默认图书与编辑的关系
	 * @param channelId 运营标识
	 * @param adviserId 编辑标识
	 * @return
	 */
	public Long createDefaultBook(Long channelId, Long adviserId);

	/**
	 * 获取默认创建的图书
	 * @param channelId 渠道标识
	 * @param adviserId 编辑标识
	 * @return
	 */
	public BookAdviserDto getDefaultBook(Long channelId, Long adviserId);

	/**
	 * 出版社下编辑的所有书刊的数目
	 * @param agentId 出版标识
	 * @return
	 */
	public Integer getBookCount(Long agentId);

	/**
	 * 更新模板
	 */
	public void updateBookTemplet(Book book);

	/**
	 * 获取图书每日新增个数-出版
	 * @param agentId 出版标识
	 */
	public List<BookCountDto> listBookCountByDate4Agent(Long agentId);

	/**
	 * 删除书籍（编辑端）
	 * @param bookId 图书标识
	 * @param adviserId 编辑标识
	 * @param channelId 渠道标识
	 */
	public void deleteBook4Adviser(Long bookId, Long adviserId, Long channelId);

	/**
	 * 恢复书籍-编辑 
	 * @param bookId 图书标识
	 * @param adviserId 编辑标识
	 * @param channelId 渠道标识
	 * @param templetId 模板标识
	 * @param secondTempletId 模板第二阶级标识
	 */
	public void recoverBook4Adviser(Long bookId, Long adviserId, Long channelId, Long templetId,Long secondTempletId, Long graLabelId, Long subLabelId, Long verLabelId, Long areaLabelId, Boolean recoverScene);

	/**
	 * 获取编辑的图书总数
	 * @param adviserId 编辑标识
	 * @return
	 */
	public CountDto getAdviserBookCount(Long adviserId);

	/**
	 * 设置图书使用模板
	 * @param bookAdviser 图书编辑关联实体
	 * @return
	 */
	public void setBookTemplet(BookAdviser bookAdviser);

	Map<String,AdviserBookInfoDTO> listAdviserBookInfo(AviserBookInfoParam aviserBookInfoParam);

	Map<Long, BookCountAndAdviserIdDTO> getBookCountByAdviserId(BookCountByAdvisersDto bookCountByAdvisersDto);

	void refactorData(Long parentId,Long originTempletId, Long secondTempletId);

    PageBeanNew<ErpAdviserBookVO> listAdviserBook4Erp(String isbn, String uniqueNumber, String adviserName, Integer currentPage, Integer numPerPage);

    /**
     * 设置书刊是否已下印状态
     * @param bookAdviser 图书编辑关联实体
     * @throws BizException
     */
    void setIsPrint(BookAdviser bookAdviser) throws BizException;

	/**
	 * 获取书刊小睿品牌介绍页权益
	 * @param bookId
	 * @param channelId
	 * @param adviserId
	 * @return
	 */
    BookRightsSettingDTO getBookRightsSetting(Long bookId, Long channelId, Long adviserId);
	/**
	 * 主编辑其中一本
	 * @param bookId
	 * @return
	 */
	BookAdviserDto getOneMainBook(Long bookId);

    PageBeanNew<QrCodeVO> getQrList(Long bookId, Long adviserId, Long channelId, Integer currentPage, Integer numPerPage);

	/**
	 * 获取书下资源总数（包括现代纸书、1V1、小睿、社群码）
	 * @param adviserIds
	 * @param bookIds
	 * @param channelIds
	 * @return
	 */
	Map<String, BookResourceStatisticsDTO> mapResourceTotalCount(List<Long> adviserIds, List<Long> bookIds, List<Long> channelIds);
}
