package com.pcloud.book.group.facade;

import com.pcloud.book.group.dto.BookGroupClassifyDTO;
import com.pcloud.book.group.dto.GroupQrcode4ClassifyDTO;
import com.pcloud.book.group.vo.AddClassifyVO;
import com.pcloud.book.group.vo.AdviserClassifyParam;
import com.pcloud.book.group.vo.AdviserClassifyVO;
import com.pcloud.book.group.vo.BookGroupClassifyVO;
import com.pcloud.book.group.vo.BookGroupQrcodeStatisticVO;
import com.pcloud.book.group.vo.ClassifyAndGroupCountVO;
import com.pcloud.book.group.vo.ClassifyAndUserCountVO;
import com.pcloud.book.group.vo.ClassifyNameVO;
import com.pcloud.book.group.vo.ClassifyVO;
import com.pcloud.book.group.vo.GroupQrcode4ClassifyVO;
import com.pcloud.book.group.vo.ListBookGroupQrcodeExportParamVO;
import com.pcloud.book.group.vo.ListBookGroupQrcodeParamVO;
import com.pcloud.book.group.vo.ListClassify4WechatVO;
import com.pcloud.book.group.vo.ListClassifyVO;
import com.pcloud.book.group.vo.ListGroupClassifyParam;
import com.pcloud.book.group.vo.PcloudBookGroupClassifyVO;
import com.pcloud.book.group.vo.StatisticVO;
import com.pcloud.book.group.vo.UpdateClassifyVO;
import com.pcloud.book.group.vo.UpdateRankVO;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.permission.PermissionException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Map;

/**
 * @author lily
 * @date 2019/4/16 21:00
 */
@Api(description = "社区群分类")
public interface BookGroupClassifyFacade {

    @ApiOperation(value = "获取所有分类列表", httpMethod = "GET")
    @RequestMapping(value = "listAllQrByGroup", method = RequestMethod.GET)
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "String", paramType = "header"),
            @ApiImplicitParam(name = "bookGroupId", value = "token", dataType = "Long", paramType = "query")
    })
    ResponseDto<List<ListClassifyVO>> listAllClassify(@RequestHeader("token") String token, @RequestParam("bookGroupId") Long bookGroupId) throws PermissionException;

    @ApiOperation(value = "新增群分类", httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "token", dataType = "String", paramType = "header"),
            @ApiImplicitParam(name = "addClassifyVO", value = "群分类", dataType = "AddClassifyVO", paramType = "body")
    })
    @PostMapping("addClassify")
    ResponseDto<?> addClassify(@RequestHeader("token") String token, @RequestBody AddClassifyVO addClassifyVO)
            throws BizException, PermissionException;

    @ApiOperation(value = "更新群分类", httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "token", dataType = "String", paramType = "header"),
            @ApiImplicitParam(name = "updateClassifyVO", value = "群分类", dataType = "UpdateClassifyVO", paramType = "body")
    })
    @PostMapping("updateClassify")
    ResponseDto<?> updateClassify(@RequestHeader("token") String token, @RequestBody UpdateClassifyVO updateClassifyVO)
            throws BizException, PermissionException;

    @ApiOperation(value = "获取群分类", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "token", dataType = "String", paramType = "header"),
            @ApiImplicitParam(name = "classifyId", value = "群分类", dataType = "Long", paramType = "query")
    })
    @GetMapping("getClassify")
    ResponseDto<ClassifyVO> getClassify(@RequestHeader("token") String token, @RequestParam("classifyId") Long classifyId)
            throws BizException, PermissionException;

    @ApiOperation(value = "删除群分类", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "token", dataType = "String", paramType = "header"),
            @ApiImplicitParam(name = "classifyId", value = "群分类标识", dataType = "Long", paramType = "query")
    })
    @PostMapping("deleteClassify")
    ResponseDto<?> deleteClassify(@RequestHeader("token") String token, @RequestParam("classifyId") Long classifyId)
            throws BizException, PermissionException;

    @ApiOperation(value = "更新排序值", httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "token", dataType = "String", paramType = "header"),
            @ApiImplicitParam(name = "updateRankVO", value = "排序", dataType = "UpdateRankVO", paramType = "body")
    })
    @PostMapping("updateClassifyRank")
    ResponseDto<?> updateClassifyRank(@RequestHeader("token") String token, @RequestBody UpdateRankVO updateRankVO)
            throws BizException, PermissionException;

    @ApiOperation(value = "获取所有分类名称", httpMethod = "GET")
    @RequestMapping(value = "listClassify", method = RequestMethod.GET)
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "String", paramType = "header"),
            @ApiImplicitParam(name = "bookGroupId", value = "token", dataType = "Long", paramType = "query")
    })
    @GetMapping("listClassify")
    ResponseDto<List<ClassifyNameVO>> listClassify(@RequestHeader("token") String token, @RequestParam("bookGroupId") Long bookGroupId);

    @ApiOperation(value = "获取分类数与群数量", httpMethod = "GET")
    @RequestMapping(value = "getClassifyAndGroupCount", method = RequestMethod.GET)
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "String", paramType = "header"),
            @ApiImplicitParam(name = "bookGroupId", value = "token", dataType = "Long", paramType = "query")
    })
    @GetMapping("getClassifyAndGroupCount")
    ResponseDto<ClassifyAndGroupCountVO> getClassifyAndGroupCount(@RequestHeader("token") String token, @RequestParam("bookGroupId") Long bookGroupId);

    @ApiOperation(value = "获取分类数与群总用户数", httpMethod = "GET")
    @RequestMapping(value = "getClassifyAndUserCount", method = RequestMethod.GET)
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "String", paramType = "header"),
            @ApiImplicitParam(name = "bookGroupId", value = "token", dataType = "Long", paramType = "query")
    })
    @GetMapping("getClassifyAndUserCount")
    ResponseDto<ClassifyAndUserCountVO> getClassifyAndUserCount(@RequestHeader("token") String token, @RequestParam("bookGroupId") Long bookGroupId);

    @ApiOperation(value = "客户端获取群分类", httpMethod = "GET")
    @RequestMapping(value = "listClassify4Wechat", method = RequestMethod.GET)
    @ApiImplicitParams({@ApiImplicitParam(name = "userInfo", value = "userInfo", dataType = "String", paramType = "header"),
            @ApiImplicitParam(name = "bookGroupId", value = "token", dataType = "Long", paramType = "query")
    })
    @GetMapping("getClassifyAndUserCount")
    ResponseDto<List<ListClassify4WechatVO>> listClassify4Wechat(@CookieValue("userInfo") String userInfo, @RequestParam("bookGroupId") Long bookGroupId);

    @ApiOperation(value = "现代纸书APP获取群分类", httpMethod = "GET")
    @RequestMapping(value = "listClassify4APP", method = RequestMethod.GET)
    @ApiImplicitParams({@ApiImplicitParam(name = "userInfo", value = "userInfo", dataType = "String", paramType = "header"),
            @ApiImplicitParam(name = "bookGroupId", value = "社群书ID", dataType = "Long", paramType = "query")
    })
    @GetMapping("listClassify4APP")
    ResponseDto<List<ListClassify4WechatVO>> listClassify4APP(@CookieValue("userInfo") String userInfo, @RequestParam("bookGroupId") Long bookGroupId);


    @ApiOperation(value = "客户端根据群分类获取二维码", httpMethod = "GET")
    @RequestMapping(value = "getGroupQrcode4ClassifyWechat", method = RequestMethod.GET)
    @ApiImplicitParams({@ApiImplicitParam(name = "userInfo", value = "userInfo", dataType = "String", paramType = "header"),
            @ApiImplicitParam(name = "classifyId", value = "分类标识", dataType = "Long", paramType = "query")
    })
    @GetMapping("getGroupQrcode4ClassifyWechat")
    ResponseDto<GroupQrcode4ClassifyVO> getGroupQrcode4ClassifyWechat(@CookieValue("userInfo") String userInfo, @RequestParam("classifyId") Long classifyId);

    @ApiOperation(value = "小程序客户端根据群分类获取二维码", httpMethod = "GET")
    @RequestMapping(value = "getGroupQrcode4Applet", method = RequestMethod.GET)
    @ApiImplicitParams({@ApiImplicitParam(name = "userInfo", value = "userInfo", dataType = "String", paramType = "header"),
            @ApiImplicitParam(name = "classifyId", value = "分类标识", dataType = "Long", paramType = "query")
    })
    @GetMapping("getGroupQrcode4Applet")
    ResponseDto<GroupQrcode4ClassifyVO> getGroupQrcode4Applet(@CookieValue("userInfo") String userInfo, @RequestParam("classifyId") Long classifyId);


    @ApiOperation(value = "获取编辑所有的分类", httpMethod = "POST")
    @RequestMapping(value = "listGroupClassifyByAdviser", method = RequestMethod.POST)
    @PostMapping("listGroupClassifyByAdviser")
    ResponseDto<PageBeanNew<BookGroupClassifyVO>> listGroupClassifyByAdviser(@RequestHeader("token") String token, @RequestBody @ApiParam("获取分类列表参数") ListGroupClassifyParam listGroupClassifyParam) throws PermissionException;

    @ApiOperation(value = "单个群统计", httpMethod = "POST")
    @RequestMapping(value = "listBookGroupQrcodeStatistic", method = RequestMethod.POST)
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "String", paramType = "header"),
            @ApiImplicitParam(name = "listBookGroupQrcodeParamVO", value = "单个群统计查询参数", dataType = "ListBookGroupQrcodeParamVO", paramType = "body")
    })
    @PostMapping("listBookGroupQrcodeStatistic")
    ResponseDto<PageBeanNew<BookGroupQrcodeStatisticVO>> listBookGroupQrcodeStatistic(@RequestHeader("token") String token, @RequestBody ListBookGroupQrcodeParamVO listBookGroupQrcodeParamVO) throws PermissionException;

    @ApiOperation(value = "单个群统计导出", httpMethod = "POST")
    @RequestMapping(value = "bookGroupQrcodeStatisticExport", method = RequestMethod.POST)
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "String", paramType = "header"),
            @ApiImplicitParam(name = "listBookGroupQrcodeExportParamVO", value = "单个群统计查询参数", dataType = "ListBookGroupQrcodeExportParamVO", paramType = "body")
    })
    @PostMapping("bookGroupQrcodeStatisticExport")
    ResponseDto<?> bookGroupQrcodeStatisticExport(@RequestHeader("token") String token, @RequestBody ListBookGroupQrcodeExportParamVO listBookGroupQrcodeExportParamVO) throws PermissionException;

    @ApiOperation(value = "获取编辑社群码统计数据", httpMethod = "GET")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "String", paramType = "header")
    })
    @GetMapping("getStatistic4Adviser")
    ResponseDto<StatisticVO> getStatistic4Adviser(@RequestHeader("token") String token) throws PermissionException;

    @ApiOperation(value = "获取编辑的所有分类", httpMethod = "POST")
    @RequestMapping(value = "listAdviserClassify", method = RequestMethod.POST)
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "String", paramType = "header"),
            @ApiImplicitParam(name = "adviserClassifyParam", value = "编辑分类参数", dataType = "AdviserClassifyParam", paramType = "body")
    })
    @PostMapping("listAdviserClassify")
    ResponseDto<PageBeanNew<AdviserClassifyVO>> listAdviserClassify(@RequestHeader("token") String token, @RequestBody AdviserClassifyParam adviserClassifyParam) throws PermissionException;

    @ApiOperation("关闭或开启学习报告")
    @GetMapping("updateHasOpenLearningReport")
    ResponseDto<?> updateHasOpenLearningReport(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestParam("classifyId") @ApiParam("分类id") Long classifyId,
            @RequestParam("hasOpenLearningReport") @ApiParam("是否开启学习报告") Boolean hasOpenLearningReport
    ) throws BizException, PermissionException;

    @ApiOperation("获取群分类学习报告相关列表")
    @GetMapping("listClassifyForLearningReport")
    ResponseDto<?> listClassifyForLearningReport(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestParam("currentPage") @ApiParam("当前页") Integer currentPage,
            @RequestParam("numPerPage") @ApiParam("每页条数") Integer numPerPage,
            @RequestParam(value = "keyword", required = false) @ApiParam("关键词") String keyword
    ) throws BizException, PermissionException;


    @ApiOperation("拖动排序")
    @PostMapping("dragSortClassify")
    ResponseDto<?> dragSortClassify(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestBody List<Long> classifyIds
    ) throws BizException, PermissionException;

    @ApiOperation("埋点记录点击分类次数")
    @GetMapping("clickClassify")
    ResponseDto<?> clickClassify(
            @CookieValue("userinfo") @ApiParam("cookie信息") String userInfo,
            @RequestParam("bookGroupId") @ApiParam("社群码id") Long bookGroupId,
            @RequestParam("classifyId") @ApiParam("群分类id") Long classifyId) throws BizException, PermissionException;

    @ApiOperation("获取所有群分类包括已删除的")
    @GetMapping("getClassifyIngoreDelete")
    ResponseDto<?> getClassifyIngoreDelete(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestParam("bookGroupId") @ApiParam("社群码id") Long bookGroupId) throws BizException, PermissionException;


    @ApiOperation("根据类型获取分类数量")
    @GetMapping("getClassifyCountByJoinGroupType")
    ResponseDto<?> getClassifyCountByJoinGroupType(
            @RequestHeader("token") String token,
            @RequestParam(value = "joinGroupType", required = false) Integer joinGroupType
    ) throws PermissionException;


    @ApiOperation("根据id获取微信群分类")
    @PostMapping("getClassifyByIds4Heals")
    ResponseDto<Map<Long, String>> getClassifyByIds4Heals(@RequestBody List<Long> classifyIds);

    @ApiOperation("根据编辑id获取所有群分类")
    @RequestMapping(value = "/getBookGroupClassifyByAdviserId", method = RequestMethod.GET)
    ResponseDto<PageBeanNew<BookGroupClassifyDTO>> getBookGroupClassifyByAdviserId(
            @RequestParam(value = "adviserId") Long adviserId,
            @RequestParam(value = "classify",required = false) String classify,
            @RequestParam(value = "currentPage") Integer currentPage ,
            @RequestParam(value = "numPerPage") Integer numPerPage
    ) throws BizException;

    @ApiOperation("根据群分类下面所有的可用的群")
    @RequestMapping(value = "/getQrcodeByClassifyId4Heals", method = RequestMethod.GET)
    ResponseDto<List<GroupQrcode4ClassifyDTO>> getQrcodeByClassifyId4Heals(
            @RequestParam(value = "classifyId") Long classifyId
    ) throws BizException;

    @ApiOperation("根据群分类下面所有的可用的群")
    @RequestMapping(value = "/getQrcodeByClassifyIds4Heals", method = RequestMethod.POST)
    ResponseDto<List<GroupQrcode4ClassifyDTO>> getQrcodeByClassifyIds4Heals(
            @RequestBody List<Long> classifyIds
    ) throws BizException;

    @ApiOperation("根据群分类下面最新可用的群")
    @GetMapping("getQrcodeInfo4Heals")
    ResponseDto<GroupQrcode4ClassifyDTO> getQrcodeInfo4Heals(@RequestParam("wechatUserId") Long wechatUserId,
                                                             @RequestParam("classifyId") Long classifyId) throws BizException;

    @ApiOperation("平台端获取群分类")
    @GetMapping("listGroupClassify4Pcloud")
    ResponseDto<PageBeanNew<PcloudBookGroupClassifyVO>> listGroupClassify4Pcloud(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestParam(value = "name", required = false) @ApiParam("群分类名 | 书刊名") String name,
            @RequestParam(value = "proLabelId", required = false) @ApiParam("专业标签") Long proLabelId,
            @RequestParam(value = "depLabelId", required = false) @ApiParam("深度标签") Long depLabelId,
            @RequestParam(value = "purLabelId", required = false) @ApiParam("目的") Long purLabelId,
            @RequestParam(value = "firstClassifyId", required = false) @ApiParam("分类") Long firstClassifyId,
            @RequestParam(value = "gradeLabelId", required = false) @ApiParam("年级") Long gradeLabelId,
            @RequestParam(value = "subjectLabelId", required = false) @ApiParam("科目") Long subjectLabelId,
            @RequestParam(value = "agentId", required = false) @ApiParam("出版社") Long agentId,
            @RequestParam(value = "adviserId", required = false) @ApiParam("编辑id") Long adviserId,
            @RequestParam("currentPage") Integer currentPage,
            @RequestParam("numPerPage") Integer numPerPage,
            @RequestParam(value = "cityCode",required = false) String cityCode) throws BizException, PermissionException;

    @ApiOperation("根据群分类ID获取群二维码")
    @GetMapping("getGroupQrcodeByClassify")
    ResponseDto<String> getGroupQrcodeByClassify(@RequestHeader("token") String token,@RequestParam("classifyId") Integer classifyId) throws BizException,PermissionException;

    @ApiOperation("根据群分类ID获取群二维码")
    @PostMapping("getBookGroupClassifyByClassifyIds")
    ResponseDto<List<BookGroupClassifyDTO>> getBookGroupClassifyByClassifyIds(@RequestBody List<Long> classifyIds) throws BizException,PermissionException;
}
