package com.pcloud.book.rightsSetting.entity;

import com.pcloud.book.applet.dto.AppletNewsServeDTO;
import com.pcloud.book.applet.entity.AppletNewsServe;
import com.pcloud.common.entity.BaseEntity;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import lombok.Data;
import lombok.NonNull;
import org.hibernate.validator.constraints.Length;

@Data
public class RightsSetting extends BaseTempletClassify {

    private String introduce;

    private String detail;

    private Integer count;

    private Long firstClassify;

    private Long secondClassify;

    private Long gradeLabelId;

    private Long subjectLabelId;

    @ApiModelProperty("线上网课是否开启")
    private Boolean onlineCourseOpen;

    @ApiModelProperty("学习工具是否开启")
    private Boolean learningToolOpen;

    @ApiModelProperty("抽奖是否开启")
    private Boolean drawNowOpen;

    @NonNull
    @ApiModelProperty("线上网课集合")
    private RightsSettingTitle onlineRightsSettingTitle;

    @NonNull
    @ApiModelProperty("学习工具集合")
    private RightsSettingTitle  learningToolTitle;

    @NonNull
    @ApiModelProperty("抽奖集合")
    private RightsSettingTitle drawSettingTitle;

    @NonNull
    @ApiModelProperty("专享礼包券集合")
    private RightsSettingTitle giftCouponPackageTitle;

    @NonNull
    @ApiModelProperty("社群集合")
    private RightsSettingTitle groupServiceTitle;

    @NonNull
    @ApiModelProperty("配套资料集合")
    private RightsSettingTitle servesTitle;

    @ApiModelProperty("本书立享权益")
    private RightsSettingNow rightsSettingNow;

    @ApiModelProperty("更新步骤类型 0 基本信息，1、本书立享权益，2，周，3，长期")
    private Integer stepType;

    @ApiModelProperty("启用专享社群服务")
    private Integer enableGroupService = 0;

    @ApiModelProperty("权益类型;【1分类权益、2书刊权益】")
    private Integer rightsSettingType = 1;

    @ApiModelProperty("书刊id")
    private Long bookId;

    @ApiModelProperty("书刊ids")
    private List<RightsSettingBookRelation> rightsSettingBookRelations;

    /**
     * 书或isbn查询
     */
    private String bookQuery;
    /**
     * 书名
     */
    private String bookName;

    /**
     * 每周权益
     */
    private List<RightsSettingItem> rightsSettingWeekItems;

    /**
     * 长期权益
     */
    private List<RightsSettingItem> rightsSettingLongTermItems;

    @ApiModelProperty("权益配套资料分组集合")
    private List<RightsItemGroup> rightsItemGroups;

    @ApiModelProperty("权益阅读方式标题")
    @Length(min=0, max=30,message = "权益阅读方式标题最大30个字")
    private String readTypeTitle;

    @ApiModelProperty("权益de阅读方式")
    @Size(min = 3,max = 3,message = "目前有且只有3种阅读方式")
    @Valid
    private List<RightsReadType> rightsReadTypes;

    /**
     * 上下册标签id
     */
    private Long volLabelId;

    @NotNull(message = "本书阅读指引不能为空")
    @ApiModelProperty("是否打开阅读指引 1：开 0：关")
    private Long guideIsOpen;

    private Long guideId;

    @NonNull
    @ApiModelProperty("阅读指引图片")
    private String guidePic;

    @ApiModelProperty("阅读指引标题")
    private String guideTitle;

    @NonNull
    @ApiModelProperty("阅读指引类型")
    private String guideType;

    @ApiModelProperty("咨询对象")
    private RightsNowItem guideNewsItem;

    @ApiModelProperty("小程序对象")
    private AppletNewsServeDTO guideAppletServe;

    public RightsSetting() {

    }
}