package com.pcloud.book.weixinclock.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.common.entity.BaseEntity;

import java.util.Date;

import io.swagger.annotations.ApiModelProperty;

/**
 * @author 杨涛
 * @description TODO
 * @date 2019/8/15 14:05
 */
public class WeixinClockReward extends BaseEntity {

    private static final long serialVersionUID = 4061202053963659184L;

    @ApiModelProperty("微信群签到打卡奖励ID")
    private Long weixinClockRewardId;

    @ApiModelProperty("微信群签到打卡ID")
    private Long weixinClockId;

    @ApiModelProperty("获取奖励需要的打卡天数")
    private Integer clockDays;

    @ApiModelProperty("获取到的抽奖次数")
    private Integer rewardNum;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("创建时间")
    private Date createTime;

    public Long getWeixinClockRewardId() {
        return weixinClockRewardId;
    }

    public void setWeixinClockRewardId(Long weixinClockRewardId) {
        this.weixinClockRewardId = weixinClockRewardId;
    }

    public Long getWeixinClockId() {
        return weixinClockId;
    }

    public void setWeixinClockId(Long weixinClockId) {
        this.weixinClockId = weixinClockId;
    }

    public Integer getClockDays() {
        return clockDays;
    }

    public void setClockDays(Integer clockDays) {
        this.clockDays = clockDays;
    }

    public Integer getRewardNum() {
        return rewardNum;
    }

    public void setRewardNum(Integer rewardNum) {
        this.rewardNum = rewardNum;
    }

    @Override
    public Date getCreateTime() {
        return createTime;
    }

    @Override
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    @Override
    public String toString() {
        return "WeixinClockReward{" +
                "weixinClockRewardId=" + weixinClockRewardId +
                ", weixinClockId=" + weixinClockId +
                ", clockDays=" + clockDays +
                ", rewardNum=" + rewardNum +
                ", createTime=" + createTime +
                '}';
    }
}
