package com.pcloud.book.applet.biz.impl;

import cn.hutool.core.util.PageUtil;
import com.alibaba.druid.sql.PagerUtils;
import com.pcloud.book.applet.biz.AppletNewsBiz;
import com.pcloud.book.applet.biz.AppletNewsPoolBiz;
import com.pcloud.book.applet.dao.AppletNewsDao;
import com.pcloud.book.applet.dao.AppletNewsPoolDAO;
import com.pcloud.book.applet.dto.AppletNewsPoolDTO;
import com.pcloud.book.applet.entity.AppletNews;
import com.pcloud.book.applet.entity.AppletNewsPool;
import com.pcloud.book.applet.enums.AppletNewsServeTypeEnum;
import com.pcloud.book.applet.enums.NewsJumpTypeEnum;
import com.pcloud.book.applet.enums.NewsTypeEnum;
import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.book.book.constant.BookConstant;
import com.pcloud.book.personalstage.enums.JumpTypeEnum;
import com.pcloud.book.rightsSetting.biz.RightsSettingBiz;
import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.page.PageParam;
import com.pcloud.common.utils.BeanUtils;
import com.pcloud.common.utils.ListUtils;
import com.pcloud.common.utils.string.StringUtil;
import com.pcloud.readercenter.common.enums.YesOrNoNumEnum;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import sun.security.krb5.internal.PAData;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
public class AppletNewsPoolBizImpl implements AppletNewsPoolBiz {

    @Autowired
    private AppletNewsPoolDAO appletNewsPoolDAO;
    @Autowired
    private AppletNewsBiz appletNewsBiz;
    @Autowired
    private RightsSettingBiz rightsSettingBiz;
    @Autowired
    private AppletNewsDao appletNewsDao;

    @Override
    @ParamLog("根据id获取详情")
    public AppletNewsPool getById(Long id) {
        return appletNewsPoolDAO.getById(id);
    }

    @Override
    @ParamLog("根据id更新资讯")
    public void update(AppletNewsPool appletNewsPool) {
        updateCheck(appletNewsPool);
        appletNewsPoolDAO.updateSelective(appletNewsPool);
    }

    @Override
    @ParamLog("资讯池批量删除")
    public void batchDelete(List<Long> ids) {
        if (ListUtils.isEmpty(ids)) {
            return;
        }
        appletNewsPoolDAO.batchDelete(ids);
    }

    @Override
    @ParamLog(value = "资讯池分页", isAfterReturn = false)
    public PageBeanNew<AppletNewsPool> listNewsPage(Integer currentPage, Integer numPerPage, String newsName, String source) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("newsName", newsName);
        paramMap.put("source", source);
        PageBeanNew<AppletNewsPool> poolPageBeanNew = appletNewsPoolDAO.listPageNew(new PageParam(currentPage, numPerPage), paramMap, "listNewsPage");
        return poolPageBeanNew;
    }

    @Override
    @ParamLog("资讯来源列表")
    public List<String> listSource() {
        return appletNewsPoolDAO.listSource();
    }

    @Override
    @ParamLog("批量从资讯池中导入资讯")
    public void batchImport(AppletNewsPoolDTO appletNewsPoolDTO) {
        importCheck(appletNewsPoolDTO);
        List<Long> appletNewsPoolIds = appletNewsPoolDTO.getAppletNewsPoolIds();
        List<AppletNews> appletNewsList = new ArrayList<>();
        Map<Long, AppletNewsPool> appletNewsPoolMap = appletNewsPoolDAO.getMapByIds(appletNewsPoolIds);
        if (MapUtils.isEmpty(appletNewsPoolMap)) {
            return;
        }
        addResource(appletNewsPoolDTO);
        appletNewsPoolIds.stream().forEach(id -> {
            AppletNews appletNews = new AppletNews();
            BeanUtils.copyProperties(appletNewsPoolDTO, appletNews);
            rightsSettingBiz.setClassifyAndLabel(appletNews);
            AppletNewsPool appletNewsPool = appletNewsPoolMap.get(id);
            if (null == appletNewsPool) {
                return;
            }
            appletNews.setNewsName(appletNewsPool.getNewsName());
            appletNews.setSource(appletNewsPool.getSource());
            appletNews.setContent(appletNewsPool.getContent());
            appletNews.setType(null == appletNewsPoolDTO.getNewsType() ? NewsTypeEnum.ONLY_PIC.code : appletNewsPoolDTO.getNewsType());
            appletNews.setPic1(null == appletNewsPoolDTO.getPic1() ? BookConstant.DEFAULT_NEWS_PIC : appletNewsPoolDTO.getPic1());
            appletNews.setJumpType(NewsJumpTypeEnum.NEWS_EDIT.code);
            appletNews.setShowSource(null == appletNewsPoolDTO.getShowSource() ? YesOrNoNumEnum.YES.getValue() : appletNewsPoolDTO.getShowSource());
            appletNewsList.add(appletNews);
        });
        if (!ListUtils.isEmpty(appletNewsList)) {
            appletNewsBiz.batchInsert(appletNewsList);
        }
    }

    private void addResource(AppletNewsPoolDTO appletNewsPoolDTO) {
        String resource = appletNewsPoolDTO.getSource();
        Boolean exist = appletNewsDao.newsSourceExist(resource);
        if (!exist) {
            appletNewsDao.insertSource(resource);
        }
        return;
    }

    private void importCheck(AppletNewsPoolDTO appletNewsPoolDTO) {
        if (null == appletNewsPoolDTO) {
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "导入资讯不能为空");
        }
        if (ListUtils.isEmpty(appletNewsPoolDTO.getAppletNewsPoolIds())) {
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "素材池id不能为空");
        }
    }

    private void updateCheck(AppletNewsPool appletNewsPool) {
        if (null == appletNewsPool) {
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "更新资讯不能为空");
        }
        if (null == appletNewsPool.getId() || StringUtil.isEmpty(appletNewsPool.getNewsName()) ||
                StringUtil.isEmpty(appletNewsPool.getSource()) || StringUtil.isEmpty(appletNewsPool.getContent())){
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "更新资讯内容不能为空");
        }
    }
}
