package com.pcloud.book.advertising.dao;

import com.pcloud.book.advertising.dto.AdvertisingBrandDTO;
import com.pcloud.book.advertising.entity.AdvertisingBrand;
import com.pcloud.common.core.dao.BaseDao;

import java.util.List;
import java.util.Map;

/**
 * @描述：广告品牌方
 * @作者：zhuyajie
 * @创建时间：15:25 2019/9/9
 * @版本：1.0
 */
public interface AdvertisingBrandDao extends BaseDao<AdvertisingBrand> {

    /**
     * 根据群id查标记的品牌方
     * @param groupQrcodeId
     * @return
     */
    List<AdvertisingBrandDTO> getByGroupQrcodeId(Long groupQrcodeId);

    /**
     * 所有品牌方列表
     * @return
     */
    List<AdvertisingBrandDTO> getAllBrand();

    /**
     * 根据登录id查品牌方id
     * @param userId
     * @return
     */
    Long getBrandIdByUserLoginId(Long userId);

    /**
     * 删除品牌方（假删除）
     * @param brandId
     */
    void deleteBrand(Long brandId);

    /**
     * 根据id查询
     * @param brandId
     * @return
     */
    AdvertisingBrandDTO getBrandById(Long brandId);

    /**
     * 品牌名称是否重复
     * @param brandName
     * @return
     */
    Boolean checkBrandNameRepeat(String brandName);

    /**
     * 登录名是否重复
     * @param loginName
     * @return
     */
    Boolean checkLoginNameRepeat(String loginName);

    /**
     * 查询登录信息
     * @param loginName
     * @return
     */
    AdvertisingBrand getLoginInfo(String loginName);

    /**
     * 根据id集合获取
     */
    Map<Long,AdvertisingBrand> getMapByIds(List<Long> brandIds);
}
