package com.pcloud.book.advertising.dao.impl;

import java.util.Map;
import org.springframework.stereotype.Repository;
import com.pcloud.book.advertising.dao.AdvertisingIncomeDailyDao;
import com.pcloud.book.advertising.entity.AdvertisingIncomeDaily;
import com.pcloud.common.core.dao.BaseDaoImpl;

/**
 * Description 广告位每日收益统计数据访问层接口实现类
 * Created by PENG on 2019/5/6.
 */
@Repository("advertisingIncomeDailyDao")
public class AdvertisingIncomeDailyDaoImpl extends BaseDaoImpl<AdvertisingIncomeDaily> implements AdvertisingIncomeDailyDao {

    /**
     * 插入扫社群码页面和作品/应用广告位的昨日收益数据
     */
    @Override
    public long insertRecordWithoutWechatGroupMsgAd(Map<String, Object> paramMap) {
        return super.getSqlSession().insert(getStatement("insertRecordWithoutWechatGroupMsgAd"), paramMap);
    }

    /**
     * 插入微信群消息广告位的昨日收益数据
     */
    @Override
    public long insertWechatGroupMsgAdRecord(Map<String, Object> paramMap) {
        return super.getSqlSession().insert(getStatement("insertWechatGroupMsgAdRecord"), paramMap);
    }
}
