package com.pcloud.book.advertising.dao.impl;

import com.pcloud.book.advertising.dao.AdvertisingLinkClickDao;
import com.pcloud.book.advertising.dto.LinkRevertRecordDTO;
import com.pcloud.book.advertising.entity.AdvertisingLinkClick;
import com.pcloud.common.core.dao.BaseDaoImpl;

import org.springframework.stereotype.Component;

/**
 * @描述：链接点击记录
 * @作者：zhuyajie
 * @创建时间：16:52 2019/10/10
 * @版本：1.0
 */
@Component("advertisingLinkClickDao")
public class AdvertisingLinkClickDaoImpl extends BaseDaoImpl<AdvertisingLinkClick> implements AdvertisingLinkClickDao {

    @Override
    public LinkRevertRecordDTO getCountByLink(String shortLink) {
        return getSessionTemplate().selectOne(getStatement("getCountByLink"), shortLink);
    }
}
