package com.pcloud.book.advertising.dao.impl;

import com.pcloud.book.advertising.dao.BmRegisterDao;
import com.pcloud.book.advertising.dto.BmRegisterDTO;
import com.pcloud.book.advertising.entity.AdvertisingBmRegister;
import com.pcloud.common.core.dao.BaseDaoImpl;

import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @描述：报名记录
 * @作者：zhuyajie
 * @创建时间：20:06 2019/6/27
 * @版本：1.0
 */
@Component("bmRegisterDao")
public class BmRegisterDaoImpl extends BaseDaoImpl<AdvertisingBmRegister> implements BmRegisterDao {
    @Override
    public List<BmRegisterDTO> getDetailByUser(Map<String, Object> paramMap) {
        return getSessionTemplate().selectList(getStatement("getDetailByUser"),paramMap);
    }

    @Override
    public Long getRegisterCountByAdId(Long adId, String statisMonth, Long bookId, Long adviserId, Long channelId) {
        Map<String, Object> map = new HashMap<>();
        map.put("adId", adId);
        map.put("statisMonth", statisMonth);
        map.put("bookId", bookId);
        map.put("adviserId", adviserId);
        map.put("channelId", channelId);
        return getSessionTemplate().selectOne(getStatement("getRegisterCountByAdId"), map);
    }

    @Override
    public Long getRegisterCountByAdIds(List<Long> adIdList) {
        return getSessionTemplate().selectOne(getStatement("getRegisterCountByAdIds"),adIdList);
    }

    @Override
    public Long getRegisterCountByAdIdQrcodeId(Long adId, String statisMonth, Long qrcodeId) {
        Map<String, Object> map = new HashMap<>();
        map.put("adId", adId);
        map.put("statisMonth", statisMonth);
        map.put("qrcodeId", qrcodeId);
        return getSessionTemplate().selectOne(getStatement("getRegisterCountByAdIdQrcodeId"), map);
    }

    @Override
    public Long getRegisterUserNumByAdIdQrcodeId(Long qrcodeId, Long adId, String statisMonth) {
        Map<String, Object> map = new HashMap<>();
        map.put("adId", adId);
        map.put("statisMonth", statisMonth);
        map.put("qrcodeId", qrcodeId);
        return getSessionTemplate().selectOne(getStatement("getRegisterUserNumByAdIdQrcodeId"), map);
    }

    @Override
    public List<BmRegisterDTO> getRegisterInfoListByAdIdQrcodeId(Long adId, String statisMonth, Long qrcodeId) {
        Map<String, Object> map = new HashMap<>();
        map.put("adId", adId);
        map.put("statisMonth", statisMonth);
        map.put("qrcodeId", qrcodeId);
        return getSessionTemplate().selectList(getStatement("getRegisterInfoListByAdIdQrcodeId"),map);
    }

    @Override
    public List<BmRegisterDTO> getRegisterInfoListByAdId(Long adId, String statisMonth, Long bookId, Long adviserId, Long channelId) {
        Map<String, Object> map = new HashMap<>();
        map.put("adId", adId);
        map.put("statisMonth", statisMonth);
        map.put("bookId", bookId);
        map.put("adviserId", adviserId);
        map.put("channelId", channelId);
        return getSessionTemplate().selectList(getStatement("getRegisterInfoListByAdId"),map);
    }

    @Override
    public Long getRegisterCountByBookId(Long bookId, Long adviserId, Long channelId, Long adId, String statisMonth) {
        Map<String, Object> map = new HashMap<>();
        map.put("bookId", bookId);
        map.put("adviserId", adviserId);
        map.put("channelId", channelId);
        map.put("adId", adId);
        map.put("statisMonth", statisMonth);
        return getSessionTemplate().selectOne(getStatement("getRegisterCountByBookId"), map);
    }


}
