/**
 * 
 */
package com.pcloud.book.book.dao;

import java.util.List;
import java.util.Map;

import com.pcloud.book.book.dto.BookProductDto;
import com.pcloud.book.book.entity.BookProduct;
import com.pcloud.common.core.dao.BaseDao;

/**
 * @描述：书籍应用数据访问层接口
 * @作者：songx
 * @创建时间：2016年12月23日,下午3:56:09 @版本：1.0
 */
public interface BookProductDao extends BaseDao<BookProduct> {

	/**
	 * 删除作品应用关联关系
	 * 
	 * @param bookProduct
	 *            书记作品关联实体
	 * @return
	 */
	public long delete(BookProduct bookProduct);

	/**
	 * 删除作品应用关联关系
	 * 
	 * @param bookId
	 *            图书标识
	 * @return
	 */
	public long deleteByBook(Long bookId);

	/**
	 * 批量删除应用关联关系
	 * 
	 * @param bookIds
	 *            图书标识列表
	 * @return
	 */
	public long deleteByBooks(List<Long> bookIds);

	/**
	 * 获取书籍关联的作品
	 * 
	 * @param bookProduct
	 *            图书作品关联实体
	 * @return
	 */
	public List<BookProductDto> getListById(BookProduct bookProduct);

	/**
	 * 根据书籍和渠道删除书籍商品关联信息
	 * 
	 * @param paramMap
	 * @return
	 */
	public Integer deleteByBookAndChannel(Map<String, Object> paramMap);

	/**
	 * 获取书籍关联作品
	 * 
	 * @param bookProduct
	 *            图书作品关联实体
	 * @return
	 */
	public Map<Long, BookProductDto> getMapById(BookProduct bookProduct);

	/**
	 * 清除录音
	 * 
	 * @param videoId
	 *            录音标识
	 * @return
	 */
	public long cleanSound(Long videoId);

	/**
	 * 获取书籍关联作品
	 */
	public List<BookProductDto> getAllBookProduct();

	/**
	 * 批量更新商品類型
	 * 
	 * @param allBookProduct
	 *            图书作品关联实体列表
	 */
	public void updateProductType(List<BookProductDto> allBookProduct);

	/**
	 * 获取与此录音相关联的书籍关联作品信息
	 * 
	 * @param videoId
	 *            录音标识
	 * @return
	 */
	public List<BookProductDto> listBySoundId(Long videoId);

	/**
	 * 获取图书关联超级作者商品个数
	 * 
	 * @param paramMap
	 * @return
	 */
	public Integer getSuperProCount(Map<String, Object> paramMap);

	/**
	 * 获取图书关联作品个数
	 * 
	 * @param paramMap
	 * @return
	 */
	public Integer getProCount(Map<String, Object> paramMap);
}
