package com.pcloud.book.book.dao.impl;

import com.google.common.collect.Maps;

import com.pcloud.book.book.dao.KeywordUseRecordDao;
import com.pcloud.book.book.entity.KeywordUseRecord;
import com.pcloud.common.core.dao.BaseDaoImpl;

import org.springframework.stereotype.Component;

import java.util.Map;

@Component
public class KeywordUseRecordDaoImpl extends BaseDaoImpl<KeywordUseRecord> implements KeywordUseRecordDao {
    @Override
    public int insertSelective(KeywordUseRecord record) {
        return this.getSqlSession().insert("com.pcloud.book.book.dao.impl.KeywordUseRecordDaoImpl.insertSelective", record);
    }

    @Override
    public KeywordUseRecord selectByPrimaryKey(Integer id) {
        return this.getSqlSession().selectOne("com.pcloud.book.book.dao.impl.KeywordUseRecordDaoImpl.selectByPrimaryKey", id);
    }

    @Override
    public int updateByPrimaryKeySelective(KeywordUseRecord record) {
        return this.getSqlSession().update("com.pcloud.book.book.dao.impl.KeywordUseRecordDaoImpl.updateByPrimaryKeySelective", record);
    }

    @Override
    public int updateByPrimaryKey(KeywordUseRecord record) {
        return this.getSqlSession().update("com.pcloud.book.book.dao.impl.KeywordUseRecordDaoImpl.updateByPrimaryKey", record);
    }

    @Override
    public KeywordUseRecord getByAdviserIdAndKeywordId(Long adviserId, Long keywordDetailId) {
        Map<String, Object> map = Maps.newHashMap();
        map.put("adviserId", adviserId);
        map.put("keywordDetailId", keywordDetailId);
        return this.getSqlSession().selectOne("com.pcloud.book.book.dao.impl.KeywordUseRecordDaoImpl.getByAdviserIdAndKeywordId", map);
    }

    @Override
    public void addOne(Long adviserId, Long id) {
        Map<String, Object> map = Maps.newHashMap();
        map.put("adviserId", adviserId);
        map.put("id", id);
        this.getSqlSession().update("com.pcloud.book.book.dao.impl.KeywordUseRecordDaoImpl.addOne", map);
    }
}
