package com.pcloud.book.book.vo;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.pcloud.book.book.entity.KeywordWarehouseDetail;
import com.pcloud.common.utils.BeanUtils;

import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

@Data
@ToString
@ApiModel
@JsonInclude(JsonInclude.Include.NON_NULL)
public class BookKeywordDetailVO {

    private List<KeywordWearhouseLabelVO> labels;

    /**
     * 分组id，一组label对应一个作品/应用
     */
    @ApiModelProperty("分组id，一组label对应一个作品/应用，那么这个整体为一组，按顺序1-15，每组不要重复")
    private Integer groupId;

    @ApiModelProperty("作品渠道id")
    private Long channelId;

    @ApiModelProperty("作品/应用标签")
    private String proLabelName;

    @ApiModelProperty("作品/应用id")
    private String depLabelName;

    @ApiModelProperty("作品/应用id")
    private String purLabelName;

    @ApiModelProperty("作品/应用id")
    private Long productId;

    @ApiModelProperty("作品/应用类型")
    private String productType;

    @ApiModelProperty("应用类型")
    private String typeCode;

    @ApiModelProperty("内容")
    private String content;

    @ApiModelProperty("应用/作品描述（答案 or 互动墙）")
    private String description;

    @ApiModelProperty("跳转链接")
    private String linkUrl;

    @ApiModelProperty("图片地址")
    private String picUrl;

    public static BookKeywordDetailVO cloneByEntity(KeywordWarehouseDetail detail) {
        if (null == detail) {
            return new BookKeywordDetailVO();
        }
        final BookKeywordDetailVO detailVO = new BookKeywordDetailVO();
        BeanUtils.copyProperties(detail, detailVO);
        return detailVO;
    }


}
