package com.pcloud.book.clock.vo.response;


import com.pcloud.book.clock.dto.BookClockListDTO;
import lombok.Data;
import org.springframework.beans.BeanUtils;

/**
 * @Describe: TODO
 * @Author: zhangdongwei
 * @Date: Create on 18:21 2019/5/28 0028
 */
@Data
public class ListBookGroupClockResponseVO {
    private Long bookClockInfoId;

    private Long originId;

    private String originType;

    private String originTitle;

    private String originImg;

    private String uniqueNumber;

    /**
     * 社群书数
     */
    private Integer bookCount;

    /**
     * 群分类数
     */
    private Integer classifyCount;

    /**
     * 群总数
     */
    private Integer bookGroupQrcodeNum;

    public Long getBookClockInfoId() {
        return bookClockInfoId;
    }

    public void setBookClockInfoId(Long bookClockInfoId) {
        this.bookClockInfoId = bookClockInfoId;
    }

    public Long getOriginId() {
        return originId;
    }

    public void setOriginId(Long originId) {
        this.originId = originId;
    }

    public String getOriginType() {
        return originType;
    }

    public void setOriginType(String originType) {
        this.originType = originType;
    }

    public String getOriginTitle() {
        return originTitle;
    }

    public void setOriginTitle(String originTitle) {
        this.originTitle = originTitle;
    }

    public String getOriginImg() {
        return originImg;
    }

    public void setOriginImg(String originImg) {
        this.originImg = originImg;
    }

    public String getUniqueNumber() {
        return uniqueNumber;
    }

    public void setUniqueNumber(String uniqueNumber) {
        this.uniqueNumber = uniqueNumber;
    }

    public Integer getBookCount() {
        return bookCount;
    }

    public void setBookCount(Integer bookCount) {
        this.bookCount = bookCount;
    }

    public Integer getClassifyCount() {
        return classifyCount;
    }

    public void setClassifyCount(Integer classifyCount) {
        this.classifyCount = classifyCount;
    }

    public Integer getBookGroupQrcodeNum() {
        return bookGroupQrcodeNum;
    }

    public void setBookGroupQrcodeNum(Integer bookGroupQrcodeNum) {
        this.bookGroupQrcodeNum = bookGroupQrcodeNum;
    }

    public static ListBookGroupClockResponseVO valueFromBookClockInfoDTO(BookClockListDTO dto){
        ListBookGroupClockResponseVO vo = new ListBookGroupClockResponseVO();
        BeanUtils.copyProperties(dto, vo);
        //去掉社群书id为0的书
        dto.getBookGroupIdList().remove(0L);
        vo.setBookCount(dto.getBookGroupIdList().size());
        return vo;
    }
}
