package com.pcloud.book.cultivate.check;

import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.book.cultivate.dto.CultivateNotifyDTO;
import com.pcloud.book.cultivate.enums.NotifySendTypeEnum;
import com.pcloud.common.utils.ListUtils;
import org.springframework.stereotype.Component;

@Component("notifyParamCheck")
public class NotifyParamCheck {

    public void createNotifyCheck(CultivateNotifyDTO cultivateNotifyDTO) {
        if(null==cultivateNotifyDTO){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"参数为空！");
        }
        if(null==cultivateNotifyDTO.getSendType()){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"发送消息类型为空！");
        }
        if(null==cultivateNotifyDTO.getMessageType()){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"消息类型为空！");
        }
        if(null==cultivateNotifyDTO.getTitle()){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"消息标题为空！");
        }
        if(ListUtils.isEmpty(cultivateNotifyDTO.getCultivateNotifyItems())){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"消息内容为空！");
        }else{
            if(cultivateNotifyDTO.getCultivateNotifyItems().size()>3) {
                throw new BookBizException(BookBizException.PARAM_IS_NULL,"消息内容不能超过3条！");
            }
        }
        if(NotifySendTypeEnum.APPOINT_USER.value.equals(cultivateNotifyDTO.getSendType())) {
            if (ListUtils.isEmpty(cultivateNotifyDTO.getWechatUserDTOS())) {
                throw new BookBizException(BookBizException.PARAM_IS_NULL, "未选择发送人！");
            }
        }
        if(NotifySendTypeEnum.CLASSIFY_USER.value.equals(cultivateNotifyDTO.getSendType())) {
            if (null==cultivateNotifyDTO.getWxId() || null==cultivateNotifyDTO.getClassifyId()) {
                throw new BookBizException(BookBizException.PARAM_IS_NULL, "小睿信息缺失！");
            }
        }
        if(NotifySendTypeEnum.BOOK_USER.value.equals(cultivateNotifyDTO.getSendType())) {
            if (null==cultivateNotifyDTO.getBookId()) {
                throw new BookBizException(BookBizException.PARAM_IS_NULL, "bookId缺失！");
            }
        }
    }
}
