package com.pcloud.book.es.facade;

import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.book.es.biz.ESBookAndAdviserBiz;
import com.pcloud.book.es.entity.ESBookAndAdviser;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @Description
 * @Author ruansiyuan
 * @Date 2019/6/13 16:43
 **/
@RestController("eesBookAndAdviserFacade")
@RequestMapping("esBookAndAdviser")
public class ESBookAndAdviserFacade {


    @Autowired
    private ESBookAndAdviserBiz esBookAndAdviserBiz;

    @ApiOperation("添加所有的书和编辑书到es")
    @PostMapping("addAllBookAndAdviserToES")
    public ResponseDto<?> addAllBookAndAdviserToES() throws BizException {
        esBookAndAdviserBiz.addAllBookAndAdviserToES();
        return new ResponseDto<>();
    }

    @ApiOperation("从es中获取编辑书")
    @GetMapping("getAdviserBooks4ES")
    public List<ESBookAndAdviser> getAdviserBooks4ES(
            @RequestParam(value = "keyword", required = false) String keyword,
            @RequestParam(value = "templetId", required = false) Long templetId,
            @RequestParam(value = "secondTempletId", required = false) Long secondTempletId,
            @RequestParam(value = "currentPage") Integer currentPage,
            @RequestParam(value = "numPerPage") Integer numPerPage
    ) throws BizException {
        if (currentPage == null || numPerPage == null || currentPage < 0 || numPerPage < 0) {
            throw BookBizException.PAGE_PARAM_DELETION;
        }
        return esBookAndAdviserBiz.getAdviserBooks4ES(keyword,templetId,secondTempletId,currentPage,numPerPage).getContent();
    }

}
