package com.pcloud.book.giftcoupon.dto;

import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.Date;

import lombok.Data;

@Data
public class MyGiftPackageDTO {

    /**
     * 券id
     */
    private Long id;
    /**
     * 封面图
     */
    private String coverPic;
    /**
     * 名称
     */
    private String title;
    /**
     * 有效期开始时间
     */
    @JsonFormat(
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    private Date validDateBegin;
    /**
     * 有效期结束时间
     */
    @JsonFormat(
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    private Date validDateEnd;
    /**
     * 面额
     */
    private Integer denomination;

    /**
     * 未使用数量
     */
    private Integer notUsedNum;
}
