package com.pcloud.book.group.dao;

import com.pcloud.book.group.dto.BookGroupCountDTO;
import com.pcloud.book.group.entity.BookGroupApp;
import com.pcloud.book.group.entity.BookGroupServe;
import com.pcloud.common.core.dao.BaseDao;

import java.util.List;

public interface BookGroupServeDao extends BaseDao<BookGroupServe> {
    Integer batchInsert(List<BookGroupServe> bookGroupServes);

    List<BookGroupServe> getListByBookGroupId(Long bookGroupId);

    void deleteByBookGroupId(Long bookGroupId);

    List<BookGroupServe> getListByServerType(String serveType);

    void updateShortUrl(Long id, String shortUrl);

    List<BookGroupServe> getProductServeList();

    List<BookGroupApp> getAllAppServe();

    Integer getCountByBookGroupId(Long bookGroupId);

    List<BookGroupServe> getListByBookGroupIds(List<Long> bookGroupIds);

    void deleteByBookGroupIds(List<Long> bookGroupIds);

    /**
     * 获取应用或作品关联的社群书数量
     * @param serveIds
     * @param serveType
     * @param adviserId
     * @return
     */
    List<BookGroupCountDTO> getCountByServeIds(List<Long> serveIds, String serveType, Long adviserId);
}
