package com.pcloud.book.mq.topic;

import com.pcloud.book.keywords.biz.BookGuideBiz;
import com.pcloud.book.mq.config.MQTopicConumer;
import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.wechatgroup.message.dto.AgreeAddUserDTO;

import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

import lombok.extern.slf4j.Slf4j;

/**
 * @author lily
 * @date 2019/5/6 11:01
 */
@Slf4j
@Component
public class WxAgreeAddUserListener {

    @Resource
    private BookGuideBiz bookGuideBiz;

    /**
     * 接收微信用户进群消息
     */
    @ParamLog("同意加好友发送欢迎语")
    @RabbitListener(queues = MQTopicConumer.WX_AGREE_ADD_USER)
    public void onMessage(AgreeAddUserDTO agreeAddUserDTO) throws BizException {
        try {
            bookGuideBiz.sendGuide(agreeAddUserDTO);
        } catch (Exception e) {
            log.error("同意加好友发送欢迎语" + e.getMessage(), e);
        }
    }
}
