package com.pcloud.book.pcloudkeyword.dao.impl;

import com.pcloud.book.pcloudkeyword.dao.PcloudClassifyTemplateDao;
import com.pcloud.book.pcloudkeyword.dao.PcloudRobotQrcodeDao;
import com.pcloud.book.pcloudkeyword.entity.PcloudClassifyTemplate;
import com.pcloud.book.pcloudkeyword.entity.PcloudRobotQrcode;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Component;

@Component("pcloudClassifyTemplateDao")
public class PcloudClassifyTemplateDaoImpl extends BaseDaoImpl<PcloudClassifyTemplate> implements PcloudClassifyTemplateDao {

    @Override
    public PcloudClassifyTemplate getTemplateByClassifyId(Integer classifyId) {
        return super.getSqlSession().selectOne(getStatement("getTemplateByClassifyId"), classifyId);
    }

    @Override
    public void updateOpenStateByClassifyId(PcloudClassifyTemplate template) {
        super.getSqlSession().update(getStatement("updateOpenStateByClassifyId"), template);
    }

    @Override
    public void updateOpenStateById(PcloudClassifyTemplate template) {
        super.getSqlSession().update(getStatement("updateOpenStateById"), template);
    }
}
