package com.pcloud.book.pcloudkeyword.dao.impl;

import com.pcloud.book.pcloudkeyword.dao.PcloudKeywordNameDao;
import com.pcloud.book.pcloudkeyword.entity.PcloudKeywordName;
import com.pcloud.common.core.dao.BaseDaoImpl;

import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component("pcloudKeywordNameDao")
public class PcloudKeywordNameDaoImpl extends BaseDaoImpl<PcloudKeywordName> implements PcloudKeywordNameDao {

    @Override
    public Integer batchInsert(List<PcloudKeywordName> list) {
        return super.getSqlSession().insert(getStatement("batchInsert"), list);
    }

    @Override
    public void deleteByPcloudKeywordId(Long pcloudKeywordId) {
        super.getSqlSession().delete(getStatement("deleteByPcloudKeywordId"), pcloudKeywordId);
    }

    @Override
    public List<PcloudKeywordName> getByPcloudKeywordId(Long pcloudKeywordId) {
        Map<String,Object> map=new HashMap<>();
        map.put("pcloudKeywordId",pcloudKeywordId);
        return super.getSqlSession().selectList(getStatement("getByPcloudKeywordId"), map);
    }

    @Override
    public List<PcloudKeywordName> getByPcloudKeywordIds(List<Long> pcloudKeywordIds) {
        Map<String,Object> map=new HashMap<>();
        map.put("pcloudKeywordIds",pcloudKeywordIds);
        return super.getSqlSession().selectList(getStatement("getByPcloudKeywordIds"), map);
    }

    @Override
    public void deleteByKeywordIds(List<Long> pcloudKeywordIds) {
        Map<String,Object> map=new HashMap<>();
        map.put("pcloudKeywordIds",pcloudKeywordIds);
        getSessionTemplate().delete(getStatement("deleteByKeywordIds"), map);
    }

    @Override
    public List<String> getNameListByClassifyId(Long keywordClassifyId, Long keywordId) {
        Map<String,Object> map=new HashMap<>();
        map.put("keywordId", keywordId);
        map.put("keywordClassifyId", keywordClassifyId);
        return getSessionTemplate().selectList(getStatement("getNameListByClassifyId"), map);
    }

}
