package com.pcloud.book.pcloudkeyword.dao.impl;

import com.pcloud.book.pcloudkeyword.dao.PcloudKeywordReplyDao;
import com.pcloud.book.pcloudkeyword.entity.PcloudKeywordReply;
import com.pcloud.common.core.dao.BaseDaoImpl;

import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component("pcloudKeywordReplyDao")
public class PcloudKeywordReplyDaoImpl extends BaseDaoImpl<PcloudKeywordReply> implements PcloudKeywordReplyDao {

    @Override
    public Integer batchInsert(List<PcloudKeywordReply> list) {
        return super.getSqlSession().insert(getStatement("batchInsert"), list);
    }

    @Override
    public void deleteByRelevance(Integer relevanceType, Long relevanceId) {
        Map<String,Object> map=new HashMap<>();
        map.put("relevanceType",relevanceType);
        map.put("relevanceId",relevanceId);
        super.getSqlSession().delete(getStatement("deleteByRelevance"), map);
    }

    @Override
    public List<PcloudKeywordReply> getByRelevance(Integer relevanceType, Long relevanceId) {
        Map<String,Object> map=new HashMap<>();
        map.put("relevanceType",relevanceType);
        map.put("relevanceId",relevanceId);
        return super.getSqlSession().selectList(getStatement("getByRelevance"), map);
    }

    @Override
    public List<PcloudKeywordReply> getByRelevances(Integer relevanceType, List<Long> relevanceIds) {
        Map<String,Object> map=new HashMap<>();
        map.put("relevanceType",relevanceType);
        map.put("relevanceIds",relevanceIds);
        return super.getSqlSession().selectList(getStatement("getByRelevances"), map);
    }

    @Override
    public void deleteByRelevanceIds(Integer relevanceType, List<Long> relevanceIds) {
        Map<String,Object> map=new HashMap<>();
        map.put("relevanceType",relevanceType);
        map.put("relevanceIds",relevanceIds);
        getSessionTemplate().delete(getStatement("deleteByRelevanceIds"), map);
    }
}
