package com.pcloud.book.push.dao.impl;

import com.pcloud.book.es.entity.ESNews;
import com.pcloud.book.push.dao.NewsDao;
import com.pcloud.book.push.entity.News;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Description
 * @Author ruansiyuan
 * @Date 2019/6/13 17:46
 **/
@Repository("newsDao")
public class NewsDaoImpl extends BaseDaoImpl<News> implements NewsDao {
    @Override
    public List<ESNews> findAll(Long maxId, Integer offset) {
        Map<String, Object> map = new HashMap<>();
        map.put("maxId", maxId);
        map.put("offset", offset);
        return super.getSqlSession().selectList(getStatement("findAll"), map);
    }

    @Override
    public Integer count() {
        return super.getSqlSession().selectOne(getStatement("count"));
    }

    @Override
    public void batchInsert(List<News> news) {
        super.getSqlSession().insert(getStatement("batchInsert"), news);
    }

    @Override
    public News getByUrl(String url) {
        Map<String, Object> map = new HashMap<>();
        map.put("url", url);
        return super.getSqlSession().selectOne(getStatement("getByUrl"), map);
    }
}
