package com.pcloud.book.push.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.Date;

/**
 * @Description
 * @Author ruansiyuan
 * @Date 2019/5/9 14:54
 **/
@JsonInclude(JsonInclude.Include.NON_NULL)
public class PushGroupDTO implements Serializable {

    private static final long serialVersionUID = -6265759654419670968L;

    @ApiModelProperty("主键id")
    private Long id;

    @ApiModelProperty("消息推送id")
    private Long pushId;

    @ApiModelProperty("书id")
    private Long bookId;

    @ApiModelProperty("分类id")
    private Long classifyId;

    @ApiModelProperty("微信二维码标识")
    private Long bookGroupQrcodeId;

    @ApiModelProperty("是否删除")
    private Boolean isDelete;

    @ApiModelProperty("创建人")
    private Long createUser;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("修改人")
    private Long updateUser;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("更新时间")
    private Date updateTime;

    @ApiModelProperty("书名")
    private String bookName;

    @ApiModelProperty("群名")
    private String groupName;


    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getPushId() {
        return pushId;
    }

    public void setPushId(Long pushId) {
        this.pushId = pushId;
    }

    public Long getBookId() {
        return bookId;
    }

    public void setBookId(Long bookId) {
        this.bookId = bookId;
    }

    public Long getClassifyId() {
        return classifyId;
    }

    public void setClassifyId(Long classifyId) {
        this.classifyId = classifyId;
    }

    public Long getBookGroupQrcodeId() {
        return bookGroupQrcodeId;
    }

    public void setBookGroupQrcodeId(Long bookGroupQrcodeId) {
        this.bookGroupQrcodeId = bookGroupQrcodeId;
    }

    public Boolean getDelete() {
        return isDelete;
    }

    public void setDelete(Boolean delete) {
        isDelete = delete;
    }

    public Long getCreateUser() {
        return createUser;
    }

    public void setCreateUser(Long createUser) {
        this.createUser = createUser;
    }

    public Long getUpdateUser() {
        return updateUser;
    }

    public void setUpdateUser(Long updateUser) {
        this.updateUser = updateUser;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public String getBookName() {
        return bookName;
    }

    public void setBookName(String bookName) {
        this.bookName = bookName;
    }

    public String getGroupName() {
        return groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    @Override
    public String toString() {
        return "PushGroupDTO{" +
                "id=" + id +
                ", pushId=" + pushId +
                ", bookId=" + bookId +
                ", classifyId=" + classifyId +
                ", bookGroupQrcodeId=" + bookGroupQrcodeId +
                ", isDelete=" + isDelete +
                ", createUser=" + createUser +
                ", createTime=" + createTime +
                ", updateUser=" + updateUser +
                ", updateTime=" + updateTime +
                ", bookName='" + bookName + '\'' +
                ", groupName='" + groupName + '\'' +
                '}';
    }
}
