package com.pcloud.book.push.entity;

import com.pcloud.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * @Description
 * @Author ruansiyuan
 * @Date 2019/4/17 15:43
 **/
@ApiModel("消息推送项模型")
public class PushItem extends BaseEntity {

    @ApiModelProperty("消息推送id")
    private Long pushId;

    @ApiModelProperty("推送内容项类型：1文本,2链接,3应用,4图片")
    private Integer itemType;

    @ApiModelProperty("排序值")
    private Integer seqNum;

    @ApiModelProperty("文本内容")
    private String textContent;

    @ApiModelProperty("链接地址")
    private String linkUrl;

    @ApiModelProperty("链接标题")
    private String linkTitle;

    @ApiModelProperty("链接简介")
    private String linkDescription;

    @ApiModelProperty("链接图片地址")
    private String linkImageUrl;

    @ApiModelProperty("图片链接")
    private String imageUrl;

    @ApiModelProperty("应用id")
    private Long appId;

    @ApiModelProperty("作品id")
    private Long productId;

    @ApiModelProperty("应用链接")
    private String appUrl;

    @ApiModelProperty("作品链接")
    private String productUrl;

    @ApiModelProperty("是否删除")
    private Boolean isDelete;

    @ApiModelProperty("创建人")
    private Long createUser;

    @ApiModelProperty("修改人")
    private Long updateUser;

    @ApiModelProperty("应用或作品名称")
    private String apName;

    @ApiModelProperty("应用或作品类型")
    private String apTypeName;

    @ApiModelProperty("应用或作品图片")
    private String apImage;

    public Long getPushId() {
        return pushId;
    }

    public void setPushId(Long pushId) {
        this.pushId = pushId;
    }

    public Integer getItemType() {
        return itemType;
    }

    public void setItemType(Integer itemType) {
        this.itemType = itemType;
    }

    public Integer getSeqNum() {
        return seqNum;
    }

    public void setSeqNum(Integer seqNum) {
        this.seqNum = seqNum;
    }

    public String getTextContent() {
        return textContent;
    }

    public void setTextContent(String textContent) {
        this.textContent = textContent;
    }

    public String getLinkUrl() {
        return linkUrl;
    }

    public void setLinkUrl(String linkUrl) {
        this.linkUrl = linkUrl;
    }

    public String getLinkTitle() {
        return linkTitle;
    }

    public void setLinkTitle(String linkTitle) {
        this.linkTitle = linkTitle;
    }

    public String getLinkDescription() {
        return linkDescription;
    }

    public void setLinkDescription(String linkDescription) {
        this.linkDescription = linkDescription;
    }

    public String getLinkImageUrl() {
        return linkImageUrl;
    }

    public void setLinkImageUrl(String linkImageUrl) {
        this.linkImageUrl = linkImageUrl;
    }

    public String getImageUrl() {
        return imageUrl;
    }

    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getProductId() {
        return productId;
    }

    public void setProductId(Long productId) {
        this.productId = productId;
    }

    public String getAppUrl() {
        return appUrl;
    }

    public void setAppUrl(String appUrl) {
        this.appUrl = appUrl;
    }

    public String getProductUrl() {
        return productUrl;
    }

    public void setProductUrl(String productUrl) {
        this.productUrl = productUrl;
    }

    public Boolean getIsDelete() {
        return isDelete;
    }

    public void setIsDelete(Boolean isDelete) {
        this.isDelete = isDelete;
    }

    public Long getCreateUser() {
        return createUser;
    }

    public void setCreateUser(Long createUser) {
        this.createUser = createUser;
    }

    public Long getUpdateUser() {
        return updateUser;
    }

    public void setUpdateUser(Long updateUser) {
        this.updateUser = updateUser;
    }

    public String getApName() {
        return apName;
    }

    public void setApName(String apName) {
        this.apName = apName;
    }

    public String getApTypeName() {
        return apTypeName;
    }

    public void setApTypeName(String apTypeName) {
        this.apTypeName = apTypeName;
    }

    public String getApImage() {
        return apImage;
    }

    public void setApImage(String apImage) {
        this.apImage = apImage;
    }

    @Override
    public String toString() {
        return "PushItem{" +
                "pushId=" + pushId +
                ", itemType=" + itemType +
                ", seqNum=" + seqNum +
                ", textContent='" + textContent + '\'' +
                ", linkUrl='" + linkUrl + '\'' +
                ", linkTitle='" + linkTitle + '\'' +
                ", linkDescription='" + linkDescription + '\'' +
                ", linkImageUrl='" + linkImageUrl + '\'' +
                ", imageUrl='" + imageUrl + '\'' +
                ", appId=" + appId +
                ", productId=" + productId +
                ", appUrl='" + appUrl + '\'' +
                ", productUrl='" + productUrl + '\'' +
                ", isDelete=" + isDelete +
                ", createUser=" + createUser +
                ", updateUser=" + updateUser +
                ", apName='" + apName + '\'' +
                ", apTypeName='" + apTypeName + '\'' +
                ", apImage='" + apImage + '\'' +
                "} " + super.toString();
    }
}
