package com.pcloud.book.reading.dao;

import com.pcloud.book.reading.dto.ReadingActivityDTO;
import com.pcloud.book.reading.entity.ReadingGroup;
import com.pcloud.common.core.dao.BaseDao;

import java.util.List;

/**
 * @描述：活动关联群
 * @作者：zhuyajie
 * @创建时间：15:30 2020/1/15
 * @版本：1.0
 */
public interface ReadingGroupDao extends BaseDao<ReadingGroup> {

    /**
     * 根据活动id获取群，有微信群
     * @param activityId
     * @return
     */
    public List<ReadingGroup> getByActivityId(Long activityId);

    /**
     * 根据群id查
     * @param wxGroupId
     * @return
     */
    public ReadingGroup getByWxGroupId(String wxGroupId);

    /**
     * 更新微信群id
     * @param wxGroupId
     * @param id
     */
    public void updateWxGroupIdById(String wxGroupId, Long id);

    /**
     * 最近无群id的群
     * @return
     */
    public ReadingGroup getLatestNullGroup(String altId);

    /**
     * getAllByActivityId
     * @param activityId
     * @return
     */
    List<ReadingGroup> getAllByActivityId(Long activityId);

    /**
     * 更新群名称
     * @param wxGroupName
     * @param id
     */
    public void updateGroupName(String wxGroupName, Long id);

    /** 根据wxGroupId查找共读活动
     * 更新群名称
     * @param wxGroupId
     */
    ReadingActivityDTO getDetailByWxGroupId(String wxGroupId);
}
