package com.pcloud.book.reading.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.common.entity.BaseEntity;

import java.util.Date;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@ApiModel("邀请语设置")
public class ReadingInvite extends BaseEntity{

    @ApiModelProperty("共读活动id")
    private Long activityId;

    @ApiModelProperty("邀请时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date inviteTime;

    @ApiModelProperty("发送类型（1文本2文件）")
    private Integer inviteType;

    @ApiModelProperty("邀请语")
    private String inviteContent;

    @ApiModelProperty("邀请语资源id")
    private String inviteResourceId;

    @ApiModelProperty("邀请语资源大小")
    private Long inviteResourceSize;

    @ApiModelProperty("邀请语资源路径名称")
    private String inviteResourceName;

    @ApiModelProperty("创建时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;

    @ApiModelProperty("创建人")
    private Long createUser;


}