package com.pcloud.book.riddle.dao.impl;

import com.pcloud.book.riddle.dao.RiddleClickRecordDao;
import com.pcloud.book.riddle.entity.RiddleClickRecord;
import com.pcloud.common.core.dao.BaseDaoImpl;

import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;

/**
 * @描述：点击记录
 * @作者：zhuyajie
 * @创建时间：18:27 2019/8/29
 * @版本：1.0
 */
@Component("riddleClickRecordDao")
public class RiddleClickRecordDaoImpl extends BaseDaoImpl<RiddleClickRecord> implements RiddleClickRecordDao {

    @Override
    public Integer getCountByType(String wxGroupId, Long wechatUserId, Integer code) {
        Map<String, Object> map = new HashMap<>();
        map.put("wxGroupId", wxGroupId);
        map.put("wechatUserId", wechatUserId);
        map.put("type", code);
        return getSessionTemplate().selectOne(getStatement("getCountByType"), map);
    }

    @Override
    public Integer getUserCountByType(String wxGroupId, Integer clickType) {
        Map<String, Object> map = new HashMap<>();
        map.put("wxGroupId", wxGroupId);
        map.put("clickType", clickType);
        return getSessionTemplate().selectOne(getStatement("getUserCountByType"), map);
    }
}
